/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import com.blazebit.persistence.spring.data.base.query.ParameterMetadataProvider;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class FixedJpaQueryCreator
extends AbstractQueryCreator<CriteriaQuery<Object>, Predicate> {
    private final CriteriaBuilder builder;
    private final Root<?> root;
    private final CriteriaQuery<Object> query;
    private final ParameterMetadataProvider provider;

    public FixedJpaQueryCreator(PartTree tree, Class<?> domainClass, CriteriaBuilder builder, ParameterMetadataProvider provider) {
        super(tree);
        this.builder = builder;
        this.query = builder.createQuery().distinct(tree.isDistinct());
        this.root = this.query.from(domainClass);
        this.provider = provider;
    }

    public List<ParameterMetadataProvider.ParameterMetadata<?>> getParameterExpressions() {
        return this.provider.getExpressions();
    }

    protected Predicate create(Part part, Iterator<Object> iterator) {
        return this.toPredicate(part, this.root);
    }

    protected Predicate and(Part part, Predicate base, Iterator<Object> iterator) {
        return this.builder.and((Expression)base, (Expression)this.toPredicate(part, this.root));
    }

    protected Predicate or(Predicate base, Predicate predicate) {
        return this.builder.or((Expression)base, (Expression)predicate);
    }

    protected final CriteriaQuery<Object> complete(Predicate predicate, Sort sort) {
        return this.complete(predicate, sort, this.query, this.builder, this.root);
    }

    protected CriteriaQuery<Object> complete(Predicate predicate, Sort sort, CriteriaQuery<Object> query, CriteriaBuilder builder, Root<?> root) {
        CriteriaQuery select = this.query.select(root).orderBy(QueryUtils.toOrders((Sort)sort, root, (CriteriaBuilder)builder));
        return predicate == null ? select : select.where((Expression)predicate);
    }

    private Predicate toPredicate(Part part, Root<?> root) {
        return new PredicateBuilder(part, root).build();
    }

    private class PredicateBuilder {
        private final Part part;
        private final Root<?> root;

        public PredicateBuilder(Part part, Root<?> root) {
            Assert.notNull((Object)part, (String)"part cannot be null");
            Assert.notNull(root, (String)"root cannot be null");
            this.part = part;
            this.root = root;
        }

        public <X> Predicate build() {
            PropertyPath property = this.part.getProperty();
            Part.Type type = this.part.getType();
            switch (type) {
                case BETWEEN: {
                    ParameterMetadataProvider.ParameterMetadata first = FixedJpaQueryCreator.this.provider.next(this.part);
                    ParameterMetadataProvider.ParameterMetadata second = FixedJpaQueryCreator.this.provider.next(this.part);
                    return FixedJpaQueryCreator.this.builder.between(this.getComparablePath(this.root, this.part), first.getExpression(), second.getExpression());
                }
                case AFTER: 
                case GREATER_THAN: {
                    return FixedJpaQueryCreator.this.builder.greaterThan(this.getComparablePath(this.root, this.part), FixedJpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case GREATER_THAN_EQUAL: {
                    return FixedJpaQueryCreator.this.builder.greaterThanOrEqualTo(this.getComparablePath(this.root, this.part), FixedJpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case BEFORE: 
                case LESS_THAN: {
                    return FixedJpaQueryCreator.this.builder.lessThan(this.getComparablePath(this.root, this.part), FixedJpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case LESS_THAN_EQUAL: {
                    return FixedJpaQueryCreator.this.builder.lessThanOrEqualTo(this.getComparablePath(this.root, this.part), FixedJpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case IS_NULL: {
                    return this.getTypedPath(this.root, this.part).isNull();
                }
                case IS_NOT_NULL: {
                    return this.getTypedPath(this.root, this.part).isNotNull();
                }
                case NOT_IN: {
                    return this.getTypedPath(this.root, this.part).in(FixedJpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression()).not();
                }
                case IN: {
                    return this.getTypedPath(this.root, this.part).in(FixedJpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression());
                }
                case STARTING_WITH: 
                case ENDING_WITH: 
                case CONTAINING: 
                case NOT_CONTAINING: {
                    if (property.getLeafProperty().isCollection()) {
                        Expression propertyExpression = this.traversePath((Path<?>)this.root, property);
                        ParameterExpression parameterExpression = FixedJpaQueryCreator.this.provider.next(this.part).getExpression();
                        return type.equals((Object)Part.Type.NOT_CONTAINING) ? FixedJpaQueryCreator.this.builder.isNotMember(parameterExpression, propertyExpression) : FixedJpaQueryCreator.this.builder.isMember(parameterExpression, propertyExpression);
                    }
                }
                case LIKE: 
                case NOT_LIKE: {
                    Expression stringPath = this.getTypedPath(this.root, this.part);
                    Expression propertyExpression = this.upperIfIgnoreCase(stringPath);
                    Expression<String> parameterExpression = this.upperIfIgnoreCase((Expression)FixedJpaQueryCreator.this.provider.next(this.part, String.class).getExpression());
                    Predicate like = FixedJpaQueryCreator.this.builder.like(propertyExpression, parameterExpression);
                    return type.equals((Object)Part.Type.NOT_LIKE) || type.equals((Object)Part.Type.NOT_CONTAINING) ? like.not() : like;
                }
                case TRUE: {
                    Expression truePath = this.getTypedPath(this.root, this.part);
                    return FixedJpaQueryCreator.this.builder.isTrue(truePath);
                }
                case FALSE: {
                    Expression falsePath = this.getTypedPath(this.root, this.part);
                    return FixedJpaQueryCreator.this.builder.isFalse(falsePath);
                }
                case SIMPLE_PROPERTY: {
                    ParameterMetadataProvider.ParameterMetadata expression = FixedJpaQueryCreator.this.provider.next(this.part);
                    Expression path = this.getTypedPath(this.root, this.part);
                    return expression.isIsNullParameter() ? path.isNull() : FixedJpaQueryCreator.this.builder.equal(this.upperIfIgnoreCase(path), this.upperIfIgnoreCase((Expression)expression.getExpression()));
                }
                case NEGATING_SIMPLE_PROPERTY: {
                    return FixedJpaQueryCreator.this.builder.notEqual(this.upperIfIgnoreCase(this.getTypedPath(this.root, this.part)), this.upperIfIgnoreCase((Expression)FixedJpaQueryCreator.this.provider.next(this.part).getExpression()));
                }
            }
            throw new IllegalArgumentException("Unsupported keyword " + type);
        }

        private <T> Expression<T> upperIfIgnoreCase(Expression<? extends T> expression) {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: {
                    Assert.state((boolean)this.canUpperCase(expression), (String)("Unable to ignore case of " + expression.getJavaType().getName() + " types, the property '" + this.part.getProperty().getSegment() + "' must reference a String"));
                    return FixedJpaQueryCreator.this.builder.upper(expression);
                }
                case WHEN_POSSIBLE: {
                    if (!this.canUpperCase(expression)) break;
                    return FixedJpaQueryCreator.this.builder.upper(expression);
                }
            }
            return expression;
        }

        private boolean canUpperCase(Expression<?> expression) {
            return String.class.equals((Object)expression.getJavaType());
        }

        private Expression<? extends Comparable> getComparablePath(Root<?> root, Part part) {
            return this.getTypedPath(root, part);
        }

        private <T> Expression<T> getTypedPath(Root<?> root, Part part) {
            return QueryUtils.toExpressionRecursively(root, (PropertyPath)part.getProperty());
        }

        private <T> Expression<T> traversePath(Path<?> root, PropertyPath path) {
            Expression<T> result = root.get(path.getSegment());
            return path.hasNext() ? this.traversePath((Path<?>)result, path.next()) : result;
        }
    }
}

