/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.ExecutionStrategy;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class ClientSideConfig {
    private static final ClientSideConfig defaultConfig = new ClientSideConfig(Versions.getLatest(), Optional.empty(), ExecutionStrategy.SAME_TREAD, Optional.empty());
    private final Version backwardCompatibilityVersion;
    private final Optional<TimeMeter> clientSideClock;
    private final ExecutionStrategy executionStrategy;
    private final Optional<Long> requestTimeoutNanos;

    protected ClientSideConfig(Version backwardCompatibilityVersion, Optional<TimeMeter> clientSideClock, ExecutionStrategy executionStrategy, Optional<Long> requestTimeoutNanos) {
        this.backwardCompatibilityVersion = Objects.requireNonNull(backwardCompatibilityVersion);
        this.clientSideClock = Objects.requireNonNull(clientSideClock);
        this.executionStrategy = executionStrategy;
        this.requestTimeoutNanos = requestTimeoutNanos;
    }

    public static ClientSideConfig getDefault() {
        return defaultConfig;
    }

    public ClientSideConfig backwardCompatibleWith(Version backwardCompatibilityVersion) {
        return new ClientSideConfig(backwardCompatibilityVersion, this.clientSideClock, this.executionStrategy, this.requestTimeoutNanos);
    }

    public ClientSideConfig withClientClock(TimeMeter clientClock) {
        return new ClientSideConfig(this.backwardCompatibilityVersion, Optional.of(clientClock), this.executionStrategy, this.requestTimeoutNanos);
    }

    public ClientSideConfig withExecutionStrategy(ExecutionStrategy executionStrategy) {
        return new ClientSideConfig(this.backwardCompatibilityVersion, this.clientSideClock, executionStrategy, this.requestTimeoutNanos);
    }

    public ClientSideConfig withRequestTimeout(Duration requestTimeout) {
        if (requestTimeout.isZero() || requestTimeout.isNegative()) {
            throw BucketExceptions.nonPositiveRequestTimeout(requestTimeout);
        }
        long requestTimeoutNanos = requestTimeout.toNanos();
        return new ClientSideConfig(this.backwardCompatibilityVersion, this.clientSideClock, this.executionStrategy, Optional.of(requestTimeoutNanos));
    }

    public Optional<TimeMeter> getClientSideClock() {
        return this.clientSideClock;
    }

    public Optional<Long> getRequestTimeoutNanos() {
        return this.requestTimeoutNanos;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }

    public ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }
}

