/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.AssertException;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

@PublicApi
public class ResultPath {
    private static final ResultPath ROOT_PATH = new ResultPath();
    private final ResultPath parent;
    private final Object segment;
    private int hash;

    public static ResultPath rootPath() {
        return ROOT_PATH;
    }

    private ResultPath() {
        this.parent = null;
        this.segment = null;
    }

    private ResultPath(ResultPath parent, String segment) {
        this.parent = Assert.assertNotNull(parent, () -> "Must provide a parent path");
        this.segment = Assert.assertNotNull(segment, () -> "Must provide a sub path");
    }

    private ResultPath(ResultPath parent, int segment) {
        this.parent = Assert.assertNotNull(parent, () -> "Must provide a parent path");
        this.segment = segment;
    }

    public int getLevel() {
        int counter = 0;
        ResultPath currentPath = this;
        while (currentPath != null) {
            if (currentPath.segment instanceof String) {
                ++counter;
            }
            currentPath = currentPath.parent;
        }
        return counter;
    }

    public ResultPath getPathWithoutListEnd() {
        if (ROOT_PATH.equals(this)) {
            return ROOT_PATH;
        }
        if (this.segment instanceof String) {
            return this;
        }
        return this.parent;
    }

    public boolean isListSegment() {
        return this.segment instanceof Integer;
    }

    public boolean isNamedSegment() {
        return this.segment instanceof String;
    }

    public String getSegmentName() {
        return (String)this.segment;
    }

    public int getSegmentIndex() {
        return (Integer)this.segment;
    }

    public Object getSegmentValue() {
        return this.segment;
    }

    public ResultPath getParent() {
        return this.parent;
    }

    public static ResultPath parse(String pathString) {
        pathString = pathString == null ? "" : pathString;
        String finalPathString = pathString.trim();
        StringTokenizer st = new StringTokenizer(finalPathString, "/[]", true);
        ResultPath path = ResultPath.rootPath();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("/".equals(token)) {
                Assert.assertTrue(st.hasMoreTokens(), () -> String.format(ResultPath.mkErrMsg(), finalPathString));
                path = path.segment(st.nextToken());
                continue;
            }
            if ("[".equals(token)) {
                Assert.assertTrue(st.countTokens() >= 2, () -> String.format(ResultPath.mkErrMsg(), finalPathString));
                path = path.segment(Integer.parseInt(st.nextToken()));
                String closingBrace = st.nextToken();
                Assert.assertTrue(closingBrace.equals("]"), () -> String.format(ResultPath.mkErrMsg(), finalPathString));
                continue;
            }
            throw new AssertException(String.format(ResultPath.mkErrMsg(), pathString));
        }
        return path;
    }

    public static ResultPath fromList(List<?> objects) {
        Assert.assertNotNull(objects);
        ResultPath path = ResultPath.rootPath();
        for (Object object : objects) {
            if (object instanceof String) {
                path = path.segment((String)object);
                continue;
            }
            path = path.segment((Integer)object);
        }
        return path;
    }

    private static String mkErrMsg() {
        return "Invalid path string : '%s'";
    }

    public ResultPath segment(String segment) {
        return new ResultPath(this, segment);
    }

    public ResultPath segment(int segment) {
        return new ResultPath(this, segment);
    }

    public ResultPath dropSegment() {
        if (this == ResultPath.rootPath()) {
            return null;
        }
        return this.parent;
    }

    public ResultPath replaceSegment(int segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ResultPath(this.parent, segment);
    }

    public ResultPath replaceSegment(String segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), () -> "You MUST not call this with the root path");
        return new ResultPath(this.parent, segment);
    }

    public boolean isRootPath() {
        return this == ROOT_PATH;
    }

    public ResultPath append(ResultPath path) {
        ArrayList<Object> objects = new ArrayList<Object>(this.toList());
        objects.addAll(Assert.assertNotNull(path).toList());
        return ResultPath.fromList(objects);
    }

    public ResultPath sibling(String siblingField) {
        Assert.assertTrue(!ROOT_PATH.equals(this), "You MUST not call this with the root path");
        return new ResultPath(this.parent, siblingField);
    }

    public ResultPath sibling(int siblingField) {
        Assert.assertTrue(!ROOT_PATH.equals(this), "You MUST not call this with the root path");
        return new ResultPath(this.parent, siblingField);
    }

    public List<Object> toList() {
        if (this.parent == null) {
            return ImmutableKit.emptyList();
        }
        LinkedList<Object> list = new LinkedList<Object>();
        ResultPath p = this;
        while (p.segment != null) {
            list.addFirst(p.segment);
            p = p.parent;
        }
        return ImmutableList.copyOf(list);
    }

    public List<String> getKeysOnly() {
        if (this.parent == null) {
            return new LinkedList<String>();
        }
        LinkedList<String> list = new LinkedList<String>();
        ResultPath p = this;
        while (p.segment != null) {
            if (p.segment instanceof String) {
                list.addFirst((String)p.segment);
            }
            p = p.parent;
        }
        return list;
    }

    public String toString() {
        if (this.parent == null) {
            return "";
        }
        if (ROOT_PATH.equals(this.parent)) {
            return this.segmentToString();
        }
        return this.parent.toString() + this.segmentToString();
    }

    public String segmentToString() {
        if (this.segment instanceof String) {
            return "/" + this.segment;
        }
        return "[" + this.segment + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultPath self = this;
        ResultPath that = (ResultPath)o;
        while (self.segment != null && that.segment != null) {
            if (!Objects.equals(self.segment, that.segment)) {
                return false;
            }
            self = self.parent;
            that = that.parent;
        }
        return self.isRootPath() && that.isRootPath();
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 1;
            ResultPath self = this;
            while (self != null) {
                Object value = self.segment;
                h = 31 * h + (value == null ? 0 : value.hashCode());
                self = self.parent;
            }
            this.hash = h;
        }
        return h;
    }
}

