/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.incremental.DeferredExecution;
import graphql.language.Argument;
import graphql.language.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class MergedField {
    private final ImmutableList<Field> fields;
    private final Field singleField;
    private final ImmutableList<DeferredExecution> deferredExecutions;

    private MergedField(ImmutableList<Field> fields, ImmutableList<DeferredExecution> deferredExecutions) {
        Assert.assertNotEmpty(fields);
        this.fields = fields;
        this.singleField = (Field)fields.get(0);
        this.deferredExecutions = deferredExecutions;
    }

    private MergedField(Field field, DeferredExecution deferredExecution) {
        this(ImmutableList.of(field), deferredExecution == null ? ImmutableList.of() : ImmutableList.of(deferredExecution));
    }

    public String getName() {
        return this.singleField.getName();
    }

    public String getResultKey() {
        return this.singleField.getResultKey();
    }

    public Field getSingleField() {
        return this.singleField;
    }

    public List<Argument> getArguments() {
        return this.singleField.getArguments();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @ExperimentalApi
    public List<DeferredExecution> getDeferredExecutions() {
        return this.deferredExecutions;
    }

    @ExperimentalApi
    public boolean isDeferred() {
        return !this.deferredExecutions.isEmpty();
    }

    public static Builder newMergedField() {
        return new Builder();
    }

    public static Builder newMergedField(Field field) {
        return new Builder().addField(field);
    }

    public static Builder newMergedField(List<Field> fields) {
        return new Builder().fields(fields);
    }

    static MergedField newSingletonMergedField(Field field, DeferredExecution deferredExecution) {
        return new MergedField(field, deferredExecution);
    }

    public MergedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergedField that = (MergedField)o;
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }

    public String toString() {
        return "MergedField{fields=" + String.valueOf(this.fields) + "}";
    }

    public static class Builder {
        private final ImmutableList.Builder<Field> fields = new ImmutableList.Builder();
        private final ImmutableList.Builder<DeferredExecution> deferredExecutions = new ImmutableList.Builder();

        private Builder() {
        }

        private Builder(MergedField existing) {
            this.fields.addAll(existing.getFields());
            this.deferredExecutions.addAll(existing.deferredExecutions);
        }

        public Builder fields(List<Field> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder addField(Field field) {
            this.fields.add((Object)field);
            return this;
        }

        public Builder addDeferredExecutions(List<DeferredExecution> deferredExecutions) {
            this.deferredExecutions.addAll(deferredExecutions);
            return this;
        }

        public Builder addDeferredExecution(@Nullable DeferredExecution deferredExecution) {
            if (deferredExecution != null) {
                this.deferredExecutions.add((Object)deferredExecution);
            }
            return this;
        }

        public MergedField build() {
            return new MergedField((ImmutableList<Field>)this.fields.build(), (ImmutableList<DeferredExecution>)this.deferredExecutions.build());
        }
    }
}

