/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.PublicApi;
import graphql.execution.instrumentation.InstrumentationContext;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class SimpleInstrumentationContext<T>
implements InstrumentationContext<T> {
    private static final InstrumentationContext<Object> NO_OP = new InstrumentationContext<Object>(){

        @Override
        public void onDispatched() {
        }

        @Override
        public void onCompleted(Object result, Throwable t) {
        }
    };
    private final BiConsumer<T, Throwable> codeToRunOnComplete;
    private final Runnable codeToRunOnDispatch;

    public static <T> InstrumentationContext<T> noOp() {
        return NO_OP;
    }

    @NotNull
    public static <T> InstrumentationContext<T> nonNullCtx(InstrumentationContext<T> nullableContext) {
        return nullableContext == null ? SimpleInstrumentationContext.noOp() : nullableContext;
    }

    public SimpleInstrumentationContext() {
        this(null, null);
    }

    private SimpleInstrumentationContext(Runnable codeToRunOnDispatch, BiConsumer<T, Throwable> codeToRunOnComplete) {
        this.codeToRunOnComplete = codeToRunOnComplete;
        this.codeToRunOnDispatch = codeToRunOnDispatch;
    }

    @Override
    public void onDispatched() {
        if (this.codeToRunOnDispatch != null) {
            this.codeToRunOnDispatch.run();
        }
    }

    @Override
    public void onCompleted(T result, Throwable t) {
        if (this.codeToRunOnComplete != null) {
            this.codeToRunOnComplete.accept(result, t);
        }
    }

    public static <U> SimpleInstrumentationContext<U> whenDispatched(Runnable codeToRun) {
        return new SimpleInstrumentationContext(codeToRun, null);
    }

    public static <U> SimpleInstrumentationContext<U> whenCompleted(BiConsumer<U, Throwable> codeToRun) {
        return new SimpleInstrumentationContext<U>(null, codeToRun);
    }

    public static <T> BiConsumer<? super T, ? super Throwable> completeInstrumentationCtxCF(InstrumentationContext<T> instrumentationContext) {
        return (result, throwable) -> SimpleInstrumentationContext.nonNullCtx(instrumentationContext).onCompleted(result, (Throwable)throwable);
    }
}

