/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Internal;
import graphql.execution.reactive.DelegatingSubscription;
import graphql.util.LockKit;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class CompletionStageSubscriber<U, D>
implements Subscriber<U> {
    protected final Function<U, CompletionStage<D>> mapper;
    protected final Subscriber<? super D> downstreamSubscriber;
    protected Subscription delegatingSubscription;
    protected final Queue<CompletionStage<?>> inFlightDataQ;
    protected final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
    protected final AtomicReference<Runnable> onCompleteRun;
    protected final AtomicBoolean isTerminal;

    public CompletionStageSubscriber(Function<U, CompletionStage<D>> mapper, Subscriber<? super D> downstreamSubscriber) {
        this.mapper = mapper;
        this.downstreamSubscriber = downstreamSubscriber;
        this.inFlightDataQ = new ArrayDeque();
        this.onCompleteRun = new AtomicReference();
        this.isTerminal = new AtomicBoolean(false);
    }

    public Subscriber<? super D> getDownstreamSubscriber() {
        return this.downstreamSubscriber;
    }

    public void onSubscribe(Subscription subscription) {
        this.delegatingSubscription = new DelegatingSubscription(subscription);
        this.downstreamSubscriber.onSubscribe(this.delegatingSubscription);
    }

    public void onNext(U u) {
        if (this.isTerminal()) {
            return;
        }
        try {
            CompletionStage<D> completionStage = this.mapper.apply(u);
            this.offerToInFlightQ(completionStage);
            completionStage.whenComplete(this.whenComplete(completionStage));
        }
        catch (RuntimeException throwable) {
            this.handleThrowableDuringMapping(throwable);
        }
    }

    @NotNull
    private BiConsumer<D, Throwable> whenComplete(CompletionStage<D> completionStage) {
        return (d, throwable) -> {
            if (this.isTerminal()) {
                return;
            }
            this.whenNextFinished(completionStage, (D)d, (Throwable)throwable);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void whenNextFinished(CompletionStage<D> completionStage, D d, Throwable throwable) {
        try {
            if (throwable != null) {
                this.handleThrowableDuringMapping(throwable);
            } else {
                this.downstreamSubscriber.onNext(d);
            }
        }
        finally {
            boolean empty = this.removeFromInFlightQAndCheckIfEmpty(completionStage);
            this.finallyAfterEachPromiseFinishes(empty);
        }
    }

    protected void finallyAfterEachPromiseFinishes(boolean isInFlightEmpty) {
        Runnable runOnCompleteOrErrorRun = this.onCompleteRun.get();
        if (isInFlightEmpty && runOnCompleteOrErrorRun != null) {
            this.onCompleteRun.set(null);
            runOnCompleteOrErrorRun.run();
        }
    }

    protected void handleThrowableDuringMapping(Throwable throwable) {
        if (this.isTerminal.compareAndSet(false, true)) {
            this.downstreamSubscriber.onError(throwable);
            this.delegatingSubscription.cancel();
            this.cancelInFlightFutures();
        }
    }

    public void onError(Throwable t) {
        if (this.isTerminal.compareAndSet(false, true)) {
            this.downstreamSubscriber.onError(t);
            this.cancelInFlightFutures();
        }
    }

    public void onComplete() {
        this.onComplete(() -> {
            if (this.isTerminal.compareAndSet(false, true)) {
                this.downstreamSubscriber.onComplete();
            }
        });
    }

    private void onComplete(Runnable doneCodeToRun) {
        if (this.inFlightQIsEmpty()) {
            doneCodeToRun.run();
        } else {
            this.onCompleteRun.set(doneCodeToRun);
        }
    }

    protected void offerToInFlightQ(CompletionStage<?> completionStage) {
        this.lock.runLocked(() -> this.inFlightDataQ.offer(completionStage));
    }

    private boolean removeFromInFlightQAndCheckIfEmpty(CompletionStage<?> completionStage) {
        return this.lock.callLocked(() -> {
            this.inFlightDataQ.remove(completionStage);
            return this.inFlightDataQ.isEmpty();
        });
    }

    private void cancelInFlightFutures() {
        this.lock.runLocked(() -> {
            while (!this.inFlightDataQ.isEmpty()) {
                CompletionStage<?> cs = this.inFlightDataQ.poll();
                if (cs == null) continue;
                cs.toCompletableFuture().cancel(false);
            }
        });
    }

    protected boolean inFlightQIsEmpty() {
        return this.lock.callLocked(this.inFlightDataQ::isEmpty);
    }

    protected boolean isTerminal() {
        return this.isTerminal.get();
    }
}

