/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Directives;
import graphql.ExperimentalApi;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.directives.QueryDirectives;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.VariableAccumulator;
import graphql.normalized.VariablePredicate;
import graphql.normalized.VariableValueWithDefinition;
import graphql.normalized.incremental.NormalizedDeferredExecution;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ExecutableNormalizedOperationToAstCompiler {
    public static CompilerResult compileToDocument(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, Map.of(), variablePredicate);
    }

    public static CompilerResult compileToDocument(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, normalizedFieldToQueryDirectives, variablePredicate, false);
    }

    @ExperimentalApi
    public static CompilerResult compileToDocumentWithDeferSupport(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocumentWithDeferSupport(schema, operationKind, operationName, topLevelFields, Map.of(), variablePredicate);
    }

    @ExperimentalApi
    public static CompilerResult compileToDocumentWithDeferSupport(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, normalizedFieldToQueryDirectives, variablePredicate, true);
    }

    private static CompilerResult compileToDocument(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate, boolean deferSupport) {
        GraphQLObjectType operationType = ExecutableNormalizedOperationToAstCompiler.getOperationType(schema, operationKind);
        VariableAccumulator variableAccumulator = new VariableAccumulator(variablePredicate);
        List<Selection<?>> selections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, operationType.getName(), topLevelFields, normalizedFieldToQueryDirectives, variableAccumulator, deferSupport);
        SelectionSet selectionSet = new SelectionSet(selections);
        OperationDefinition.Builder definitionBuilder = OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind).selectionSet(selectionSet);
        definitionBuilder.variableDefinitions(variableAccumulator.getVariableDefinitions());
        return new CompilerResult(Document.newDocument().definition(definitionBuilder.build()).build(), variableAccumulator.getVariablesMap());
    }

    private static List<Selection<?>> subselectionsForNormalizedField(GraphQLSchema schema, @NotNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        if (deferSupport) {
            return ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedFieldWithDeferSupport(schema, parentOutputType, executableNormalizedFields, normalizedFieldToQueryDirectives, variableAccumulator);
        }
        return ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedFieldNoDeferSupport(schema, parentOutputType, executableNormalizedFields, normalizedFieldToQueryDirectives, variableAccumulator);
    }

    private static List<Selection<?>> subselectionsForNormalizedFieldNoDeferSupport(GraphQLSchema schema, @NotNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<String, List> fieldsByTypeCondition = new LinkedHashMap<String, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            if (nf.isConditional(schema)) {
                ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf, normalizedFieldToQueryDirectives, variableAccumulator, false).forEach((objectTypeName, field) -> fieldsByTypeCondition.computeIfAbsent((String)objectTypeName, ignored -> new ArrayList()).add(field));
                continue;
            }
            selections.add(ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, false));
        }
        fieldsByTypeCondition.forEach((objectTypeName, fields) -> {
            TypeName typeName = TypeName.newTypeName(objectTypeName).build();
            InlineFragment inlineFragment = InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields)).build();
            selections.add(inlineFragment);
        });
        return selections.build();
    }

    private static List<Selection<?>> subselectionsForNormalizedFieldWithDeferSupport(GraphQLSchema schema, @NotNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<ExecutionFragmentDetails, List> fieldsByFragmentDetails = new LinkedHashMap<ExecutionFragmentDetails, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            LinkedHashSet<NormalizedDeferredExecution> deferredExecutions = nf.getDeferredExecutions();
            if (nf.isConditional(schema)) {
                ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf, normalizedFieldToQueryDirectives, variableAccumulator, true).forEach((objectTypeName, field) -> {
                    if (deferredExecutions == null || deferredExecutions.isEmpty()) {
                        fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails((String)objectTypeName, null), ignored -> new ArrayList()).add(field);
                    } else {
                        deferredExecutions.forEach(deferredExecution -> fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails((String)objectTypeName, (NormalizedDeferredExecution)deferredExecution), ignored -> new ArrayList()).add(field));
                    }
                });
                continue;
            }
            if (deferredExecutions != null && !deferredExecutions.isEmpty()) {
                Field field2 = ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, true);
                deferredExecutions.forEach(deferredExecution -> fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails(null, (NormalizedDeferredExecution)deferredExecution), ignored -> new ArrayList()).add(field2));
                continue;
            }
            selections.add(ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, true));
        }
        fieldsByFragmentDetails.forEach((typeAndDeferPair, fields) -> {
            InlineFragment.Builder fragmentBuilder = InlineFragment.newInlineFragment().selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields));
            if (typeAndDeferPair.typeName != null) {
                TypeName typeName = TypeName.newTypeName(typeAndDeferPair.typeName).build();
                fragmentBuilder.typeCondition(typeName);
            }
            if (typeAndDeferPair.deferredExecution != null) {
                Directive.Builder deferBuilder = Directive.newDirective().name(Directives.DeferDirective.getName());
                if (typeAndDeferPair.deferredExecution.getLabel() != null) {
                    deferBuilder.argument(Argument.newArgument().name("label").value(StringValue.of(typeAndDeferPair.deferredExecution.getLabel())).build());
                }
                fragmentBuilder.directive(deferBuilder.build());
            }
            selections.add(fragmentBuilder.build());
        });
        return selections.build();
    }

    private static Map<String, Field> selectionForNormalizedField(GraphQLSchema schema, ExecutableNormalizedField executableNormalizedField, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        LinkedHashMap<String, Field> groupedFields = new LinkedHashMap<String, Field>();
        for (String objectTypeName : executableNormalizedField.getObjectTypeNames()) {
            groupedFields.put(objectTypeName, ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, objectTypeName, executableNormalizedField, normalizedFieldToQueryDirectives, variableAccumulator, deferSupport));
        }
        return groupedFields;
    }

    private static Field selectionForNormalizedField(GraphQLSchema schema, String objectTypeName, ExecutableNormalizedField executableNormalizedField, @NotNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        List<Selection<?>> subSelections;
        if (executableNormalizedField.getChildren().isEmpty()) {
            subSelections = ImmutableKit.emptyList();
        } else {
            GraphQLFieldDefinition fieldDef = ExecutableNormalizedOperationToAstCompiler.getFieldDefinition(schema, objectTypeName, executableNormalizedField);
            GraphQLUnmodifiedType fieldOutputType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            subSelections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, fieldOutputType.getName(), executableNormalizedField.getChildren(), normalizedFieldToQueryDirectives, variableAccumulator, deferSupport);
        }
        SelectionSet selectionSet = ExecutableNormalizedOperationToAstCompiler.selectionSetOrNullIfEmpty(subSelections);
        List<Argument> arguments = ExecutableNormalizedOperationToAstCompiler.createArguments(executableNormalizedField, variableAccumulator);
        QueryDirectives queryDirectives = normalizedFieldToQueryDirectives.get(executableNormalizedField);
        Field.Builder builder = Field.newField().name(executableNormalizedField.getFieldName()).alias(executableNormalizedField.getAlias()).selectionSet(selectionSet).arguments(arguments);
        if (queryDirectives == null || queryDirectives.getImmediateAppliedDirectivesByField().isEmpty()) {
            return builder.build();
        }
        List directives = queryDirectives.getImmediateAppliedDirectivesByField().keySet().stream().flatMap(field -> field.getDirectives().stream()).collect(Collectors.toList());
        return ((Field.Builder)builder.directives(directives)).build();
    }

    @Nullable
    private static SelectionSet selectionSetOrNullIfEmpty(List<Selection<?>> selections) {
        return selections.isEmpty() ? null : SelectionSet.newSelectionSet().selections(selections).build();
    }

    private static SelectionSet selectionSet(List<Field> fields) {
        return SelectionSet.newSelectionSet().selections(fields).build();
    }

    private static List<Argument> createArguments(ExecutableNormalizedField executableNormalizedField, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap<String, NormalizedInputValue> normalizedArguments = executableNormalizedField.getNormalizedArguments();
        for (String argName : normalizedArguments.keySet()) {
            NormalizedInputValue normalizedInputValue = normalizedArguments.get(argName);
            Value<?> value = ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, normalizedInputValue, variableAccumulator);
            Argument argument = Argument.newArgument().name(argName).value(value).build();
            result.add(argument);
        }
        return result.build();
    }

    private static Value<?> argValue(ExecutableNormalizedField executableNormalizedField, String argName, @Nullable Object value, VariableAccumulator variableAccumulator) {
        if (value instanceof List) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            arrayValue.values(ImmutableKit.map((List)value, val -> ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, val, variableAccumulator)));
            return arrayValue.build();
        }
        if (value instanceof Map) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            Map map = (Map)value;
            for (String fieldName : map.keySet()) {
                Value<?> fieldValue = ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, (NormalizedInputValue)map.get(fieldName), variableAccumulator);
                objectValue.objectField(ObjectField.newObjectField().name(fieldName).value(fieldValue).build());
            }
            return objectValue.build();
        }
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        return (Value)value;
    }

    @NotNull
    private static Value<?> argValue(ExecutableNormalizedField executableNormalizedField, String argName, NormalizedInputValue normalizedInputValue, VariableAccumulator variableAccumulator) {
        if (variableAccumulator.shouldMakeVariable(executableNormalizedField, argName, normalizedInputValue)) {
            VariableValueWithDefinition variableWithDefinition = variableAccumulator.accumulateVariable(normalizedInputValue);
            return variableWithDefinition.getVariableReference();
        }
        return ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, normalizedInputValue.getValue(), variableAccumulator);
    }

    @NotNull
    private static GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, String parentType, ExecutableNormalizedField nf) {
        return Introspection.getFieldDef(schema, (GraphQLCompositeType)schema.getType(parentType), nf.getName());
    }

    @Nullable
    private static GraphQLObjectType getOperationType(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind) {
        switch (operationKind) {
            case QUERY: {
                return schema.getQueryType();
            }
            case MUTATION: {
                return schema.getMutationType();
            }
            case SUBSCRIPTION: {
                return schema.getSubscriptionType();
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unknown operation kind " + String.valueOf((Object)operationKind), new Object[0]);
    }

    private static class ExecutionFragmentDetails {
        private final String typeName;
        private final NormalizedDeferredExecution deferredExecution;

        public ExecutionFragmentDetails(String typeName, NormalizedDeferredExecution deferredExecution) {
            this.typeName = typeName;
            this.deferredExecution = deferredExecution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionFragmentDetails that = (ExecutionFragmentDetails)o;
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.deferredExecution, that.deferredExecution);
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.deferredExecution);
        }
    }

    public static class CompilerResult {
        private final Document document;
        private final Map<String, Object> variables;

        public CompilerResult(Document document, Map<String, Object> variables) {
            this.document = document;
            this.variables = variables;
        }

        public Document getDocument() {
            return this.document;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

