/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.ValuesResolver;
import graphql.language.Argument;
import graphql.language.Value;
import graphql.schema.GraphQLInputSchemaElement;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.InputValueWithState;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class GraphQLAppliedDirectiveArgument
implements GraphQLNamedSchemaElement,
GraphQLInputSchemaElement {
    private final String name;
    private final InputValueWithState value;
    private final GraphQLInputType originalType;
    private GraphQLInputType replacedType;
    private final Argument definition;
    public static final String CHILD_TYPE = "type";

    private GraphQLAppliedDirectiveArgument(String name, InputValueWithState value, GraphQLInputType type, Argument definition) {
        Assert.assertValidName(name);
        this.name = name;
        this.value = Assert.assertNotNull(value);
        this.originalType = Assert.assertNotNull(type);
        this.definition = definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.replacedType != null ? this.replacedType : this.originalType;
    }

    void replaceType(GraphQLInputType type) {
        this.replacedType = type;
    }

    public boolean hasSetValue() {
        return this.value.isSet();
    }

    @NotNull
    public InputValueWithState getArgumentValue() {
        return this.value;
    }

    public <T> T getValue() {
        return ValuesResolver.getInputValueImpl(this.getType(), this.value, GraphQLContext.getDefault(), Locale.getDefault());
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public Argument getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.add(this.getType());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(CHILD_TYPE, this.originalType).build();
    }

    @Override
    public GraphQLAppliedDirectiveArgument withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.type((GraphQLInputType)newChildren.getChildOrNull(CHILD_TYPE)));
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLAppliedDirectiveArgument.newArgument(this).build();
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public GraphQLAppliedDirectiveArgument transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLAppliedDirectiveArgument.newArgument(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newArgument() {
        return new Builder();
    }

    public static Builder newArgument(GraphQLAppliedDirectiveArgument existing) {
        return new Builder(existing);
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLAppliedDirectiveArgument(this, context);
    }

    public String toString() {
        return "GraphQLAppliedDirectiveArgument{name='" + this.name + "', type=" + String.valueOf(this.getType()) + ", value=" + String.valueOf(this.value) + "}";
    }

    public static class Builder
    extends GraphqlTypeBuilder<Builder> {
        private InputValueWithState value = InputValueWithState.NOT_SET;
        private Argument definition;
        private GraphQLInputType type;

        public Builder() {
        }

        public Builder(GraphQLAppliedDirectiveArgument existing) {
            this.name = existing.getName();
            this.value = existing.getArgumentValue();
            this.type = existing.getType();
        }

        public Builder type(GraphQLInputType type) {
            this.type = Assert.assertNotNull(type);
            return this;
        }

        public Builder definition(Argument definition) {
            this.definition = definition;
            return this;
        }

        public Builder valueLiteral(@NotNull Value<?> value) {
            this.value = InputValueWithState.newLiteralValue(value);
            return this;
        }

        public Builder valueProgrammatic(@Nullable Object value) {
            this.value = InputValueWithState.newExternalValue(value);
            return this;
        }

        public Builder inputValueWithState(@NotNull InputValueWithState value) {
            this.value = Assert.assertNotNull(value);
            return this;
        }

        public Builder clearValue() {
            this.value = InputValueWithState.NOT_SET;
            return this;
        }

        public GraphQLAppliedDirectiveArgument build() {
            return new GraphQLAppliedDirectiveArgument(this.name, this.value, this.type, this.definition);
        }
    }
}

