/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.Internal;
import graphql.Scalars;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.fetching.LambdaFetchingSupport;
import graphql.util.StringKit;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Internal
public class PropertyFetchingImpl {
    private final AtomicBoolean USE_SET_ACCESSIBLE = new AtomicBoolean(true);
    private final AtomicBoolean USE_LAMBDA_FACTORY = new AtomicBoolean(true);
    private final AtomicBoolean USE_NEGATIVE_CACHE = new AtomicBoolean(true);
    private final ConcurrentMap<CacheKey, CachedLambdaFunction> LAMBDA_CACHE = new ConcurrentHashMap<CacheKey, CachedLambdaFunction>();
    private final ConcurrentMap<CacheKey, CachedMethod> METHOD_CACHE = new ConcurrentHashMap<CacheKey, CachedMethod>();
    private final ConcurrentMap<CacheKey, Field> FIELD_CACHE = new ConcurrentHashMap<CacheKey, Field>();
    private final ConcurrentMap<CacheKey, CacheKey> NEGATIVE_CACHE = new ConcurrentHashMap<CacheKey, CacheKey>();
    private final Class<?> singleArgumentType;

    public PropertyFetchingImpl(Class<?> singleArgumentType) {
        this.singleArgumentType = singleArgumentType;
    }

    public Object getPropertyValue(String propertyName, Object object, GraphQLType graphQLType, boolean dfeInUse, Supplier<?> singleArgumentValue) {
        Field cachedField;
        if (object instanceof Map) {
            return ((Map)object).get(propertyName);
        }
        CacheKey cacheKey = this.mkCacheKey(object, propertyName);
        CachedLambdaFunction cachedFunction = (CachedLambdaFunction)this.LAMBDA_CACHE.get(cacheKey);
        if (cachedFunction != null) {
            return cachedFunction.getter.apply(object);
        }
        CachedMethod cachedMethod = (CachedMethod)this.METHOD_CACHE.get(cacheKey);
        if (cachedMethod != null) {
            try {
                return this.invokeMethod(object, singleArgumentValue, cachedMethod.method, cachedMethod.takesSingleArgumentTypeAsOnlyArgument);
            }
            catch (NoSuchMethodException ignored) {
                Assert.assertShouldNeverHappen("A method cached as '%s' is no longer available??", cacheKey);
            }
        }
        if ((cachedField = (Field)this.FIELD_CACHE.get(cacheKey)) != null) {
            return this.invokeField(object, cachedField);
        }
        if (this.isNegativelyCached(cacheKey)) {
            return null;
        }
        Optional<Function<Object, Object>> getterOpt = this.lambdaGetter(propertyName, object);
        if (getterOpt.isPresent()) {
            try {
                Function<Object, Object> getter = getterOpt.get();
                Object value = getter.apply(object);
                cachedFunction = new CachedLambdaFunction(getter);
                this.LAMBDA_CACHE.putIfAbsent(cacheKey, cachedFunction);
                return value;
            }
            catch (ClassCastException | LinkageError getter) {
                // empty catch block
            }
        }
        try {
            MethodFinder methodFinder = (rootClass, methodName) -> this.findRecordMethod(cacheKey, rootClass, methodName);
            return this.getPropertyViaRecordMethod(object, propertyName, methodFinder, singleArgumentValue);
        }
        catch (NoSuchMethodException methodFinder) {
            try {
                MethodFinder methodFinder2 = (rootClass, methodName) -> this.findPubliclyAccessibleMethod(cacheKey, rootClass, methodName, dfeInUse, false);
                return this.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder2, singleArgumentValue);
            }
            catch (NoSuchMethodException methodFinder2) {
                try {
                    MethodFinder methodFinder3 = (rootClass, methodName) -> this.findPubliclyAccessibleMethod(cacheKey, rootClass, methodName, dfeInUse, true);
                    return this.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder3, singleArgumentValue);
                }
                catch (NoSuchMethodException methodFinder3) {
                    try {
                        MethodFinder methodFinder4 = (aClass, methodName) -> this.findViaSetAccessible(cacheKey, aClass, methodName, dfeInUse);
                        return this.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder4, singleArgumentValue);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            return this.getPropertyViaFieldAccess(cacheKey, object, propertyName);
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            this.putInNegativeCache(cacheKey);
                            return null;
                        }
                    }
                }
            }
        }
    }

    private Optional<Function<Object, Object>> lambdaGetter(String propertyName, Object object) {
        if (this.USE_LAMBDA_FACTORY.get()) {
            return LambdaFetchingSupport.createGetter(object.getClass(), propertyName);
        }
        return Optional.empty();
    }

    private boolean isNegativelyCached(CacheKey key) {
        if (this.USE_NEGATIVE_CACHE.get()) {
            return this.NEGATIVE_CACHE.containsKey(key);
        }
        return false;
    }

    private void putInNegativeCache(CacheKey key) {
        if (this.USE_NEGATIVE_CACHE.get()) {
            this.NEGATIVE_CACHE.put(key, key);
        }
    }

    private Object getPropertyViaRecordMethod(Object object, String propertyName, MethodFinder methodFinder, Supplier<?> singleArgumentValue) throws NoSuchMethodException {
        Method method = methodFinder.apply(object.getClass(), propertyName);
        return this.invokeMethod(object, singleArgumentValue, method, this.takesSingleArgumentTypeAsOnlyArgument(method));
    }

    private Object getPropertyViaGetterMethod(Object object, String propertyName, GraphQLType graphQLType, MethodFinder methodFinder, Supplier<?> singleArgumentValue) throws NoSuchMethodException {
        if (this.isBooleanProperty(graphQLType)) {
            try {
                return this.getPropertyViaGetterUsingPrefix(object, propertyName, "is", methodFinder, singleArgumentValue);
            }
            catch (NoSuchMethodException e) {
                return this.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, singleArgumentValue);
            }
        }
        return this.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, singleArgumentValue);
    }

    private Object getPropertyViaGetterUsingPrefix(Object object, String propertyName, String prefix, MethodFinder methodFinder, Supplier<?> singleArgumentValue) throws NoSuchMethodException {
        String getterName = prefix + StringKit.capitalize(propertyName);
        Method method = methodFinder.apply(object.getClass(), getterName);
        return this.invokeMethod(object, singleArgumentValue, method, this.takesSingleArgumentTypeAsOnlyArgument(method));
    }

    private Method findPubliclyAccessibleMethod(CacheKey cacheKey, Class<?> rootClass, String methodName, boolean dfeInUse, boolean allowStaticMethods) throws NoSuchMethodException {
        for (Class<?> currentClass = rootClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method method;
            if (!Modifier.isPublic(currentClass.getModifiers())) continue;
            if (dfeInUse) {
                try {
                    method = currentClass.getMethod(methodName, this.singleArgumentType);
                    if (this.isSuitablePublicMethod(method, allowStaticMethods)) {
                        this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
                        return method;
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
            }
            if (!this.isSuitablePublicMethod(method = currentClass.getMethod(methodName, new Class[0]), allowStaticMethods)) continue;
            this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
            return method;
        }
        assert (rootClass != null);
        return rootClass.getMethod(methodName, new Class[0]);
    }

    private boolean isSuitablePublicMethod(Method method, boolean allowStaticMethods) {
        int methodModifiers = method.getModifiers();
        if (Modifier.isPublic(methodModifiers)) {
            return !Modifier.isStatic(methodModifiers) || allowStaticMethods;
        }
        return false;
    }

    private Method findRecordMethod(CacheKey cacheKey, Class<?> rootClass, String methodName) throws NoSuchMethodException {
        return this.findPubliclyAccessibleMethod(cacheKey, rootClass, methodName, false, false);
    }

    private Method findViaSetAccessible(CacheKey cacheKey, Class<?> aClass, String methodName, boolean dfeInUse) throws NoSuchMethodException {
        if (!this.USE_SET_ACCESSIBLE.get()) {
            throw new FastNoSuchMethodException(methodName);
        }
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Predicate<Method> whichMethods = mth -> {
                if (dfeInUse) {
                    return this.hasZeroArgs((Method)mth) || this.takesSingleArgumentTypeAsOnlyArgument((Method)mth);
                }
                return this.hasZeroArgs((Method)mth);
            };
            Method[] declaredMethods = currentClass.getDeclaredMethods();
            Optional<? super Method> m = Arrays.stream(declaredMethods).filter(mth -> methodName.equals(mth.getName())).filter(whichMethods).min(PropertyFetchingImpl.mostMethodArgsFirst());
            if (!m.isPresent()) continue;
            try {
                Method method = m.get();
                method.setAccessible(true);
                this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
                return method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new FastNoSuchMethodException(methodName);
    }

    private Object getPropertyViaFieldAccess(CacheKey cacheKey, Object object, String propertyName) throws FastNoSuchMethodException {
        Class<?> aClass = object.getClass();
        try {
            Field field = aClass.getField(propertyName);
            this.FIELD_CACHE.putIfAbsent(cacheKey, field);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            if (!this.USE_SET_ACCESSIBLE.get()) {
                throw new FastNoSuchMethodException(cacheKey.toString());
            }
            try {
                Field field = aClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                this.FIELD_CACHE.putIfAbsent(cacheKey, field);
                return field.get(object);
            }
            catch (NoSuchFieldException | SecurityException ignored2) {
                throw new FastNoSuchMethodException(cacheKey.toString());
            }
            catch (IllegalAccessException e1) {
                throw new GraphQLException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private Object invokeMethod(Object object, Supplier<?> singleArgumentValue, Method method, boolean takesSingleArgument) throws FastNoSuchMethodException {
        try {
            if (takesSingleArgument) {
                Object argValue = singleArgumentValue.get();
                if (argValue == null) {
                    throw new FastNoSuchMethodException(method.getName());
                }
                return method.invoke(object, argValue);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
    }

    private Object invokeField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLType graphQLType) {
        if (graphQLType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull(graphQLType)) {
            return GraphQLTypeUtil.unwrapOne(graphQLType) == Scalars.GraphQLBoolean;
        }
        return false;
    }

    public void clearReflectionCache() {
        this.LAMBDA_CACHE.clear();
        this.METHOD_CACHE.clear();
        this.FIELD_CACHE.clear();
        this.NEGATIVE_CACHE.clear();
    }

    public boolean setUseSetAccessible(boolean flag) {
        return this.USE_SET_ACCESSIBLE.getAndSet(flag);
    }

    public boolean setUseLambdaFactory(boolean flag) {
        return this.USE_LAMBDA_FACTORY.getAndSet(flag);
    }

    public boolean setUseNegativeCache(boolean flag) {
        return this.USE_NEGATIVE_CACHE.getAndSet(flag);
    }

    private CacheKey mkCacheKey(Object object, String propertyName) {
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return new CacheKey(classLoader, clazz.getName(), propertyName);
    }

    private boolean hasZeroArgs(Method mth) {
        return mth.getParameterCount() == 0;
    }

    private boolean takesSingleArgumentTypeAsOnlyArgument(Method mth) {
        return mth.getParameterCount() == 1 && mth.getParameterTypes()[0].equals(this.singleArgumentType);
    }

    private static Comparator<? super Method> mostMethodArgsFirst() {
        return Comparator.comparingInt(Method::getParameterCount).reversed();
    }

    private static class FastNoSuchMethodException
    extends NoSuchMethodException {
        public FastNoSuchMethodException(String methodName) {
            super(methodName);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class CacheKey {
        private final ClassLoader classLoader;
        private final String className;
        private final String propertyName;

        private CacheKey(ClassLoader classLoader, String className, String propertyName) {
            this.classLoader = classLoader;
            this.className = className;
            this.propertyName = propertyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.classLoader, cacheKey.classLoader) && Objects.equals(this.className, cacheKey.className) && Objects.equals(this.propertyName, cacheKey.propertyName);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.classLoader);
            result = 31 * result + Objects.hashCode(this.className);
            result = 31 * result + Objects.hashCode(this.propertyName);
            return result;
        }

        public String toString() {
            return "CacheKey{classLoader=" + String.valueOf(this.classLoader) + ", className='" + this.className + "', propertyName='" + this.propertyName + "'}";
        }
    }

    private static interface MethodFinder {
        public Method apply(Class<?> var1, String var2) throws NoSuchMethodException;
    }

    private static final class CachedLambdaFunction {
        private final Function<Object, Object> getter;

        CachedLambdaFunction(Function<Object, Object> getter) {
            this.getter = getter;
        }
    }

    private final class CachedMethod {
        private final Method method;
        private final boolean takesSingleArgumentTypeAsOnlyArgument;

        CachedMethod(Method method) {
            this.method = method;
            this.takesSingleArgumentTypeAsOnlyArgument = PropertyFetchingImpl.this.takesSingleArgumentTypeAsOnlyArgument(method);
        }
    }
}

