/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import java.util.List;

public class OracleDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "oracle";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String DATABASE_NAME = "Oracle";
    private static final String BOOLEAN_INTEGER_FORMAT = "integer";

    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    protected void appendStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("VARCHAR2(").append(fieldWidth).append(')');
    }

    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG");
    }

    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMERIC");
    }

    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG RAW");
    }

    protected void appendBigDecimalNumericType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMBER(*," + fieldWidth + ")");
    }

    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (BOOLEAN_INTEGER_FORMAT.equalsIgnoreCase(fieldType.getFormat())) {
            sb.append("INTEGER");
        } else {
            sb.append("CHAR(1)");
        }
    }

    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                if (BOOLEAN_INTEGER_FORMAT.equalsIgnoreCase(fieldType.getFormat())) {
                    return DataType.BOOLEAN_INTEGER.getDataPersister();
                }
                return DataType.BOOLEAN_CHAR.getDataPersister();
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        String seqName = fieldType.getGeneratedIdSequence();
        StringBuilder seqSb = new StringBuilder(64);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, seqName);
        statementsBefore.add(seqSb.toString());
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
    }

    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    public boolean isIdSequenceNeeded() {
        return true;
    }

    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("SELECT ");
        this.appendEscapedEntityName(sb, sequenceName);
        sb.append(".nextval FROM dual");
    }

    public String getPingStatement() {
        return "SELECT 1 FROM DUAL";
    }

    public boolean isOffsetSqlSupported() {
        return false;
    }

    public boolean isBatchUseTransaction() {
        return true;
    }

    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }
}

