/*
 * Decompiled with CFR 0.152.
 */
package utils;

import utils.SkippingIterator;

public abstract class AbstractSkippingIterator<T>
implements SkippingIterator<T> {
    protected long cursor = -1L;

    @Override
    public long getCursor() {
        return this.cursor;
    }

    @Override
    public boolean hasNext() {
        return this.cursor + 1L < this.getTotalCount();
    }

    @Override
    public long skip(long skippingCount) {
        if (skippingCount < 0L) {
            throw new IllegalArgumentException("The specified count is out of bound!");
        }
        if (skippingCount == 0L) {
            return 0L;
        }
        long count = this.getTotalCount();
        if (this.cursor + skippingCount < count) {
            this.cursor += skippingCount;
            return skippingCount;
        }
        long skipped = count - this.cursor - 1L;
        this.cursor = count - 1L;
        return skipped;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        T v = this.get(this.cursor + 1L);
        ++this.cursor;
        return v;
    }

    protected T get(long cursor) {
        throw new UnsupportedOperationException();
    }
}

