/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import utils.ByteSequence;
import utils.codec.Base58Utils;
import utils.io.BytesSerializable;
import utils.io.BytesUtils;
import utils.io.RuntimeIOException;

public class Bytes
implements ByteSequence,
BytesSerializable,
Serializable {
    private static final long serialVersionUID = 4774903322403127601L;
    public static final int INIT_CODE = 1;
    public static final Bytes EMPTY = new Bytes(BytesUtils.EMPTY_BYTES);
    private static final int MAX_CACHE = 256;
    private static Bytes[] INT_BYTES = new Bytes[256];
    private static Bytes[] LONG_BYTES = new Bytes[256];
    private final Bytes prefix;
    private final int prefixSize;
    private final byte[] bytes;
    private final int hashCode;

    @Override
    public int size() {
        return this.prefixSize + this.bytes.length;
    }

    public Bytes() {
        this.prefix = null;
        this.prefixSize = 0;
        this.bytes = BytesUtils.EMPTY_BYTES;
        this.hashCode = this.hashCode(1);
    }

    public Bytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes data is null!");
        }
        this.prefix = null;
        this.prefixSize = 0;
        this.bytes = bytes;
        this.hashCode = this.hashCode(1);
    }

    public Bytes(Bytes prefix, byte[] bytes) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix is null!");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes data is null!");
        }
        this.prefix = prefix;
        this.prefixSize = prefix.size();
        this.bytes = bytes;
        this.hashCode = this.hashCode(1);
    }

    public Bytes(Bytes prefix, Bytes bytes) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix is null!");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes data is null!");
        }
        this.prefix = prefix;
        this.prefixSize = prefix.size();
        this.bytes = bytes.toBytes();
        this.hashCode = this.hashCode(1);
    }

    public byte read(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is negative!");
        }
        if (index < this.prefixSize) {
            return this.prefix.read(index);
        }
        if (index < this.prefixSize + this.bytes.length) {
            return this.bytes[index - this.prefixSize];
        }
        throw new IndexOutOfBoundsException("Index is negative!");
    }

    protected byte[] getDirectBytes() {
        return this.bytes;
    }

    public static Bytes fromString(String str) {
        return new Bytes(BytesUtils.toBytes(str));
    }

    public static Bytes fromBase58(String base58Str) {
        return new Bytes(Base58Utils.decode(base58Str));
    }

    public Bytes concat(ByteSequence key) {
        if (key instanceof Bytes) {
            return new Bytes(this, (Bytes)key);
        }
        byte[] newBytes = new byte[key.size()];
        key.copyTo(newBytes, 0, newBytes.length);
        return new Bytes(this, newBytes);
    }

    public Bytes concat(Bytes key) {
        return new Bytes(this, key);
    }

    public Bytes concat(byte[] key) {
        return new Bytes(this, key);
    }

    public int writeTo(OutputStream out) {
        int size = 0;
        if (this.prefix != null) {
            size = this.prefix.writeTo(out);
        }
        try {
            out.write(this.bytes);
            return size += this.bytes.length;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    private int hashCode(int initCode) {
        if (this.prefix != null) {
            initCode = this.prefix.hashCode(initCode);
        }
        return this.hashCode(initCode, this.bytes);
    }

    private int hashCode(int initCode, byte[] bytes) {
        for (byte element : bytes) {
            initCode = 31 * initCode + element;
        }
        return initCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof byte[]) {
            return this.equals((byte[])obj);
        }
        if (obj instanceof Bytes) {
            return this.equals((Bytes)obj);
        }
        return false;
    }

    public boolean equals(Bytes oth) {
        if (oth == null) {
            return false;
        }
        if (this == oth) {
            return true;
        }
        if (this.hashCode != oth.hashCode) {
            return false;
        }
        int size = this.size();
        if (size != oth.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.read(i) == oth.read(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] oth) {
        if (oth == null) {
            return false;
        }
        int size = this.size();
        if (size != oth.length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.read(i) == oth[i]) continue;
            return false;
        }
        return true;
    }

    public int compare(Bytes bytes2) {
        int len1 = this.size();
        int len2 = bytes2.size();
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            if (this.read(i) == bytes2.read(i)) continue;
            return this.read(i) < bytes2.read(i) ? -1 : 1;
        }
        if (len1 == len2) {
            return 0;
        }
        return len1 < len2 ? -1 : 1;
    }

    public int compare(byte[] bytes2) {
        int len1 = this.size();
        int len2 = bytes2.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            if (this.read(i) == bytes2[i]) continue;
            return this.read(i) < bytes2[i] ? -1 : 1;
        }
        if (len1 == len2) {
            return 0;
        }
        return len1 < len2 ? -1 : 1;
    }

    public static int compare(byte[] bytes1, byte[] bytes2) {
        int len1 = bytes1.length;
        int len2 = bytes2.length;
        int len = Math.min(len1, len2);
        for (int i = 0; i < len; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return bytes1[i] < bytes2[i] ? -1 : 1;
        }
        if (len1 == len2) {
            return 0;
        }
        return len1 < len2 ? -1 : 1;
    }

    @Override
    public int copyTo(byte[] buffer, int offset, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Argument len is negative!");
        }
        if (len == 0) {
            return 0;
        }
        int s = 0;
        if (this.prefix != null) {
            s = this.prefix.copyTo(buffer, offset, len);
        }
        if (s < len) {
            int l = len - s;
            l = l < this.bytes.length ? l : this.bytes.length;
            System.arraycopy(this.bytes, 0, buffer, offset + s, l);
            s += l;
        }
        return s;
    }

    @Override
    public int copyTo(int sourceOffset, byte[] target, int targetOffset, int len) {
        if (sourceOffset < 0) {
            throw new IllegalArgumentException("Argument sourceOffset is negative!");
        }
        if (targetOffset < 0) {
            throw new IllegalArgumentException("Argument targetOffset is negative!");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Argument len is negative!");
        }
        if (len == 0) {
            return 0;
        }
        int s = 0;
        if (this.prefix != null && sourceOffset < this.prefix.size()) {
            s = this.prefix.copyTo(target, targetOffset, len);
        }
        if (s < len) {
            int l = len - s;
            l = l < this.bytes.length ? l : this.bytes.length;
            System.arraycopy(this.bytes, 0, target, targetOffset + s, l);
            s += l;
        }
        return s;
    }

    @Override
    public byte[] toBytes() {
        if (this.prefix == null || this.prefix.size() == 0) {
            return (byte[])this.bytes.clone();
        }
        int size = this.size();
        byte[] buffer = new byte[size];
        this.copyTo(buffer, 0, size);
        return buffer;
    }

    public String toBase58() {
        return Base58Utils.encode(this.toBytes());
    }

    public static Bytes fromInt(int value) {
        if (value > -1 && value < 256) {
            return INT_BYTES[value];
        }
        return new Bytes(BytesUtils.toBytes(value));
    }

    public String toUTF8String() {
        return BytesUtils.toString(this.toBytes());
    }

    public String toString(String charset) {
        return BytesUtils.toString(this.toBytes(), charset);
    }

    public static Bytes fromLong(long value) {
        if (value > -1L && value < 256L) {
            return LONG_BYTES[(int)value];
        }
        return new Bytes(BytesUtils.toBytes(value));
    }

    public String toString() {
        return this.toBase58();
    }

    @Override
    public byte byteAt(int index) {
        return this.read(index);
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("Start index of subsequence is out of bounds!");
        }
        int s = end - start;
        if (s < 0 || s > this.size()) {
            throw new IndexOutOfBoundsException("End index of subsequence is out of bounds!");
        }
        return new SubSequence(this, start, s);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Bytes.INT_BYTES[i] = new Bytes(BytesUtils.toBytes(i));
            Bytes.LONG_BYTES[i] = new Bytes(BytesUtils.toBytes((long)i));
        }
    }

    private static class SubSequence
    implements ByteSequence {
        private int offset;
        private int size;
        private ByteSequence bytes;

        public SubSequence(ByteSequence bytes, int offset, int size) {
            this.bytes = bytes;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public byte byteAt(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index of subsequence is out of bounds!");
            }
            return this.bytes.byteAt(this.offset + index);
        }

        @Override
        public ByteSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("Start index of subsequence is out of bounds!");
            }
            int s = end - start;
            if (s < 0 || s > this.size) {
                throw new IndexOutOfBoundsException("End index of subsequence is out of bounds!");
            }
            return new SubSequence(this.bytes, this.offset + start, s);
        }

        @Override
        public int copyTo(int sourceOffset, byte[] target, int targetOffset, int len) {
            return this.bytes.copyTo(this.offset + sourceOffset, target, targetOffset, len);
        }
    }
}

