/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import utils.ConsoleReader;
import utils.io.ByteArray;
import utils.io.RuntimeIOException;

public class ConsoleUtils {
    private static volatile ConsoleReader consoleReader;

    public static byte[] readPassword() {
        char[] pwdChars;
        Console cs = ConsoleUtils.getConsole();
        while ((pwdChars = cs.readPassword("\r\nInput password:", new Object[0])).length == 0) {
        }
        String pwd = new String(pwdChars);
        return ByteArray.fromString(pwd, "UTF-8");
    }

    public static void info(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static void error(String format, Object ... args) {
        System.err.println(String.format(format, args));
    }

    public static String confirm(String fmt, Object ... args) {
        Console cs = ConsoleUtils.getConsole();
        return cs.readLine(fmt, args);
    }

    public static Console getConsole() {
        Console cs = System.console();
        if (cs == null) {
            throw new IllegalStateException("You are not running in console!");
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsoleReader getReader() {
        if (consoleReader != null) return consoleReader;
        Class<ConsoleUtils> clazz = ConsoleUtils.class;
        synchronized (ConsoleUtils.class) {
            if (consoleReader != null) return consoleReader;
            Console cs = System.console();
            consoleReader = cs == null ? new SystemInputReader() : new SystemConsoleReader(cs);
            // ** MonitorExit[var0] (shouldn't be in output)
            return consoleReader;
        }
    }

    private static class SystemInputReader
    implements ConsoleReader {
        private InputStreamReader reader = new InputStreamReader(System.in);
        private BufferedReader bufReader = new BufferedReader(this.reader);

        private SystemInputReader() {
        }

        @Override
        public String readLine() {
            try {
                return this.bufReader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
    }

    private static class SystemConsoleReader
    implements ConsoleReader {
        private Console cs;

        public SystemConsoleReader(Console cs) {
            this.cs = cs;
        }

        @Override
        public String readLine() {
            return this.cs.readLine();
        }
    }
}

