/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.HashMap;
import java.util.Map;

public class PrimitiveUtils {
    private static Map<Class<?>, Converter> converters = new HashMap();

    public static boolean isWrapping(Class<?> type1, Class<?> type2) {
        Converter converter = converters.get(type1);
        return converter != null && converter.isWrapping(type2);
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return converters.containsKey(clazz);
    }

    public static Object getDefaultValue(Class<?> clazz) {
        Converter converter = converters.get(clazz);
        if (converter == null) {
            return null;
        }
        return converter.defaultValue();
    }

    public static <T> T castTo(Object data, Class<T> clazz) {
        Converter converter = converters.get(clazz);
        if (converter == null) {
            return null;
        }
        return (T)converter.convert(data);
    }

    static {
        converters.put(Boolean.class, new BooleanConverter());
        converters.put(Boolean.TYPE, new BooleanValueConverter());
        converters.put(Byte.class, new ByteConverter());
        converters.put(Byte.TYPE, new ByteValueConverter());
        converters.put(Character.class, new CharConverter());
        converters.put(Character.TYPE, new CharValueConverter());
        converters.put(Integer.class, new IntegerConverter());
        converters.put(Integer.TYPE, new IntegerValueConverter());
        converters.put(Long.class, new LongConverter());
        converters.put(Long.TYPE, new LongValueConverter());
        converters.put(Double.class, new DoubleConverter());
        converters.put(Double.TYPE, new DoubleValueConverter());
        converters.put(Float.class, new FloatConverter());
        converters.put(Float.TYPE, new FloatValueConverter());
    }

    private static class FloatValueConverter
    extends FloatConverter {
        private static final Float DEFAULT_FLOAT = Float.valueOf(0.0f);

        private FloatValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Float value = (Float)super.convert(data);
            if (value == null) {
                return DEFAULT_FLOAT;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return Float.valueOf(0.0f);
        }
    }

    private static class FloatConverter
    implements Converter {
        private FloatConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Float) {
                return (Float)data;
            }
            if (data instanceof Long) {
                return Float.valueOf(((Long)data).floatValue());
            }
            if (data instanceof Integer) {
                return Float.valueOf(((Integer)data).floatValue());
            }
            if (data instanceof Byte) {
                return Float.valueOf(((Byte)data).floatValue());
            }
            return Float.valueOf(Float.parseFloat(data.toString()));
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Float.TYPE || type == Float.class;
        }
    }

    private static class DoubleValueConverter
    extends DoubleConverter {
        private DoubleValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Long value = (Long)super.convert(data);
            if (value == null) {
                return 0L;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return 0.0;
        }
    }

    private static class DoubleConverter
    implements Converter {
        private DoubleConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Double) {
                return (Double)data;
            }
            if (data instanceof Float) {
                return ((Float)data).doubleValue();
            }
            if (data instanceof Long) {
                return ((Long)data).doubleValue();
            }
            if (data instanceof Integer) {
                return ((Integer)data).doubleValue();
            }
            if (data instanceof Byte) {
                return ((Byte)data).doubleValue();
            }
            return Double.parseDouble(data.toString());
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Double.TYPE || type == Double.class;
        }
    }

    private static class LongValueConverter
    extends LongConverter {
        private LongValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Long value = (Long)super.convert(data);
            if (value == null) {
                return 0L;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return 0L;
        }
    }

    private static class LongConverter
    implements Converter {
        private LongConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Long) {
                return (Long)data;
            }
            if (data instanceof Integer) {
                return ((Integer)data).longValue();
            }
            if (data instanceof Byte) {
                return ((Byte)data).longValue();
            }
            return Long.parseLong(data.toString());
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Long.TYPE || type == Long.class;
        }
    }

    private static class IntegerValueConverter
    extends IntegerConverter {
        private IntegerValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Integer value = (Integer)super.convert(data);
            if (value == null) {
                return 0;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return 0;
        }
    }

    private static class IntegerConverter
    implements Converter {
        private IntegerConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
            if (data instanceof Byte) {
                return ((Byte)data).intValue();
            }
            return Integer.parseInt(data.toString());
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Integer.TYPE || type == Integer.class;
        }
    }

    private static class ByteValueConverter
    extends ByteConverter {
        private ByteValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Byte value = (Byte)super.convert(data);
            if (value == null) {
                return (byte)0;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return (byte)0;
        }
    }

    private static class ByteConverter
    implements Converter {
        private ByteConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Byte) {
                return (int)((Byte)data).byteValue();
            }
            return Byte.parseByte(data.toString());
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Byte.TYPE || type == Byte.class;
        }
    }

    private static class CharValueConverter
    extends CharConverter {
        private CharValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Character value = (Character)super.convert(data);
            if (value == null) {
                throw new IllegalArgumentException("Cann't convert null charater to char!");
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return Character.valueOf('\u0000');
        }
    }

    private static class CharConverter
    implements Converter {
        private CharConverter() {
        }

        @Override
        public Object convert(Object data) {
            String str;
            if (data == null) {
                return null;
            }
            if (data instanceof Character) {
                return Character.valueOf(((Character)data).charValue());
            }
            if (data instanceof Byte) {
                return Character.valueOf((char)((Byte)data).byteValue());
            }
            if (data instanceof String && (str = (String)data).length() == 1) {
                return Character.valueOf(str.charAt(0));
            }
            throw new IllegalArgumentException("Cann't conver [" + data + "] to charater!");
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Character.TYPE || type == Character.class;
        }
    }

    private static class BooleanValueConverter
    extends BooleanConverter {
        private BooleanValueConverter() {
        }

        @Override
        public Object convert(Object data) {
            Boolean value = (Boolean)super.convert(data);
            if (value == null) {
                return false;
            }
            return value;
        }

        @Override
        public Object defaultValue() {
            return false;
        }
    }

    private static class BooleanConverter
    implements Converter {
        private BooleanConverter() {
        }

        @Override
        public Object convert(Object data) {
            if (data == null) {
                return null;
            }
            if (data instanceof Boolean) {
                return (Boolean)data;
            }
            return Boolean.parseBoolean(data.toString());
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public boolean isWrapping(Class<?> type) {
            return type == Boolean.TYPE || type == Boolean.class;
        }
    }

    private static interface Converter {
        public Object defaultValue();

        public Object convert(Object var1);

        public boolean isWrapping(Class<?> var1);
    }
}

