/*
 * Decompiled with CFR 0.152.
 */
package utils.codec;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import utils.codec.DataDecodeException;

public class HexUtils {
    public static byte[] decode(String hexString) {
        try {
            return Hex.decodeHex((char[])hexString.toCharArray());
        }
        catch (DecoderException e) {
            throw new DataDecodeException(e.getMessage(), e);
        }
    }

    public static String encode(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }

    public static String encode(ByteBuffer bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[64];
        while (bytes.remaining() > 0) {
            int len = Math.min(buf.length, bytes.remaining());
            bytes.get(buf, 0, len);
            out.write(buf, 0, len);
        }
        return Hex.encodeHexString((byte[])out.toByteArray());
    }

    public static boolean isHex(String hexString) {
        String regex = "^[A-Fa-f0-9]+$";
        return hexString.matches(regex);
    }
}

