/*
 * Decompiled with CFR 0.152.
 */
package utils.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private String name;
    private boolean indexThread = false;
    private AtomicLong index;
    private boolean deamon;

    public NamedThreadFactory(String name) {
        this(name, false, false);
    }

    public NamedThreadFactory(String name, boolean deamon) {
        this(name, false, deamon);
    }

    public NamedThreadFactory(String name, boolean indexThread, boolean deamon) {
        this.name = name;
        this.indexThread = indexThread;
        if (indexThread) {
            this.index = new AtomicLong(0L);
        }
        this.deamon = deamon;
    }

    @Override
    public Thread newThread(Runnable r) {
        String thrdName = this.name;
        if (this.indexThread) {
            long i = this.index.incrementAndGet();
            thrdName = this.name + "-" + i;
        }
        Thread thrd = new Thread(r, thrdName);
        thrd.setDaemon(this.deamon);
        return thrd;
    }
}

