/*
 * Decompiled with CFR 0.152.
 */
package utils.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import utils.Disposable;
import utils.event.ExceptionHandle;
import utils.event.RethrowExceptionHandler;

public class EventMulticaster<TListener>
implements Disposable {
    private TListener listenerProxy;
    private Method[] supportedMethods;
    private List<TListener> listeners = new CopyOnWriteArrayList<TListener>();
    private ExceptionHandle<TListener> exHandle;

    public EventMulticaster(Class<TListener> listenerClass) {
        this(listenerClass, (ExceptionHandle)null);
    }

    public EventMulticaster(Class<TListener> listenerClass, Logger errorLogger) {
        this(listenerClass, new RethrowExceptionHandler(errorLogger));
    }

    public EventMulticaster(Class<TListener> listenerClass, ExceptionHandle<TListener> exHandle) {
        if (!listenerClass.isInterface()) {
            throw new IllegalArgumentException("The specified class of listener does not represent an interface!");
        }
        this.exHandle = exHandle == null ? new RethrowExceptionHandler(LoggerFactory.getLogger(EventMulticaster.class)) : exHandle;
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(listenerClass);
        ArrayList<Method> supMths = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getDeclaringClass() == Object.class || method.getReturnType() != Void.TYPE) continue;
            supMths.add(method);
        }
        this.supportedMethods = supMths.toArray(new Method[supMths.size()]);
        this.listenerProxy = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                EventMulticaster.this.multicast(proxy, method, args);
                return null;
            }
        });
    }

    private void multicast(Object proxy, Method method, Object[] args) {
        boolean supported = false;
        for (Method mth : this.supportedMethods) {
            if (!mth.equals(method)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            throw new UnsupportedOperationException("Unsupported method for event multicasting!");
        }
        this.doNotify(this.listeners, method, args);
    }

    protected void doNotify(List<TListener> listeners, Method method, Object[] args) {
        for (TListener listener : listeners) {
            this.doNotifySingle(listener, method, args);
        }
    }

    protected void doNotifySingle(TListener listener, Method method, Object[] args) {
        try {
            ReflectionUtils.invokeMethod((Method)method, listener, (Object[])args);
        }
        catch (Exception e) {
            this.exHandle.handle(e, listener, method, args);
        }
    }

    public void addListener(TListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TListener listener) {
        this.listeners.remove(listener);
    }

    public TListener getBroadcaster() {
        return this.listenerProxy;
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        this.listeners = null;
        this.listenerProxy = null;
        this.supportedMethods = null;
        this.exHandle = null;
    }
}

