/*
 * Decompiled with CFR 0.152.
 */
package utils.id;

import utils.id.KeyGenerator;

public class KeyGeneratorFactory {
    private static final char[] base36 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private char[][] baseChars;

    private KeyGeneratorFactory(char[][] baseChars) {
        if (baseChars.length == 0) {
            throw new IllegalArgumentException("Empty baseChars!");
        }
        for (char[] cs : baseChars) {
            if (cs != null && cs.length != 0) continue;
            throw new IllegalArgumentException("Empty baseChars!");
        }
        this.baseChars = baseChars;
    }

    public static KeyGeneratorFactory createBase36Instance(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("The len is less than or equal zero!");
        }
        char[][] baseChars = new char[len][];
        for (int i = 0; i < baseChars.length; ++i) {
            baseChars[i] = base36;
        }
        return new KeyGeneratorFactory(baseChars);
    }

    public KeyGenerator createKeyGenerator() {
        return new CommonKeyGenerator();
    }

    private class CommonKeyGenerator
    implements KeyGenerator {
        private int[] indexes;

        private CommonKeyGenerator() {
            this.indexes = new int[KeyGeneratorFactory.this.baseChars.length];
        }

        @Override
        public String next() {
            int i;
            StringBuilder key = new StringBuilder();
            for (i = 0; i < KeyGeneratorFactory.this.baseChars.length; ++i) {
                key.append(KeyGeneratorFactory.this.baseChars[i][this.indexes[i]]);
            }
            int n = KeyGeneratorFactory.this.baseChars.length - 1;
            this.indexes[n] = this.indexes[n] + 1;
            for (i = this.indexes.length - 1; i > -1; --i) {
                if (this.indexes[i] != KeyGeneratorFactory.this.baseChars[i].length) continue;
                if (i > 0) {
                    int n2 = i - 1;
                    this.indexes[n2] = this.indexes[n2] + 1;
                }
                this.indexes[i] = 0;
            }
            return key.toString();
        }
    }
}

