/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.springframework.util.Base64Utils;
import utils.ByteSequence;
import utils.codec.Base58Utils;
import utils.codec.HexUtils;
import utils.io.BytesSlice;
import utils.io.BytesUtils;
import utils.io.RuntimeIOException;

public class ByteArray
implements Externalizable,
ByteSequence {
    public static final ByteArray EMPTY = ByteArray.wrap(new byte[0]);
    private byte[] bytes;
    private int hashCode;
    private ByteArray readonlyWrapper = null;

    private ByteArray(byte[] bytes) {
        this(bytes, false);
    }

    private ByteArray(byte[] bytes, boolean readonly) {
        this.bytes = bytes;
        this.hashCode = Arrays.hashCode(bytes);
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    public byte get(int i) {
        return this.bytes[i];
    }

    public void copy(int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(this.bytes, srcPos, dest, destPos, length);
    }

    public ByteArray() {
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteArray)) {
            return false;
        }
        ByteArray target = (ByteArray)obj;
        if (this.bytes == target.bytes) {
            return true;
        }
        return BytesUtils.equals(target.bytes, this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public static ByteArray wrapCopy(byte[] bytes) {
        byte[] replica = Arrays.copyOf(bytes, bytes.length);
        return new ByteArray(replica);
    }

    public static ByteArray wrap(byte[] bytes) {
        return new ByteArray(bytes);
    }

    public static ByteArray wrap(byte oneByte) {
        return new ByteArray(new byte[]{oneByte});
    }

    public static ByteArray wrapCopyReadonly(byte[] bytes) {
        byte[] replica = Arrays.copyOf(bytes, bytes.length);
        return new ByteArray(replica, true);
    }

    public static ByteArray wrapReadonly(byte[] bytes) {
        return new ByteArray(bytes, true);
    }

    public static ByteArray wrapReadonly(byte oneByte) {
        return new ByteArray(new byte[]{oneByte}, true);
    }

    public int writeTo(OutputStream out) {
        try {
            out.write(this.bytes);
            return this.bytes.length;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ByteBuffer.wrap(this.bytes).asReadOnlyBuffer();
    }

    public byte[] bytesCopy() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    @Override
    public int copyTo(int sourceOffset, byte[] dest, int destOffset, int length) {
        System.arraycopy(this.bytes, sourceOffset, dest, destOffset, length);
        return length;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toHex() {
        return ByteArray.toHex(this.bytes);
    }

    public String toBase64() {
        return ByteArray.toBase64(this.bytes);
    }

    public String toBase58() {
        return ByteArray.toBase58(this.bytes);
    }

    public String toString() {
        return this.toBase58();
    }

    public static ByteArray parseHex(String hexString) {
        return ByteArray.wrap(ByteArray.fromHex(hexString));
    }

    public static ByteArray parseBase58(String base58String) {
        return ByteArray.wrap(ByteArray.fromBase58(base58String));
    }

    public static ByteArray parseBase64(String base64String) {
        return ByteArray.wrap(ByteArray.fromBase64(base64String));
    }

    public static ByteArray parseString(String str, String charset) {
        return ByteArray.wrap(ByteArray.fromString(str, charset));
    }

    public static String toHex(byte[] bytes) {
        return HexUtils.encode(bytes);
    }

    public static String toBase58(byte[] bytes) {
        return Base58Utils.encode(bytes);
    }

    public static String toBase64(byte[] bytes) {
        return Base64Utils.encodeToUrlSafeString((byte[])bytes);
    }

    public String toString(String charset) {
        return BytesUtils.toString(this.bytes, charset);
    }

    public static byte[] fromHex(String hexString) {
        return HexUtils.decode(hexString);
    }

    public static byte[] fromBase58(String base58String) {
        return Base58Utils.decode(base58String);
    }

    public static byte[] fromBase64(String base64String) {
        return Base64Utils.decodeFromUrlSafeString((String)base64String);
    }

    public static byte[] fromString(String str, String charset) {
        return BytesUtils.toBytes(str, charset);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeTo(os);
        byte[] bts = os.toByteArray();
        out.writeInt(bts.length);
        out.write(bts);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] bts = new byte[len];
        in.readFully(bts);
        this.bytes = bts;
    }

    @Override
    public byte byteAt(int index) {
        return this.bytes[index];
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        return new BytesSlice(this.bytes, start, end - start);
    }
}

