/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import utils.IllegalDataException;
import utils.io.BytesUtils;

public class BytesChunkReader
implements Closeable {
    private byte[] magicBytes;
    private InputStream in;

    public BytesChunkReader(String magicString, InputStream in) throws IOException {
        this.magicBytes = magicString.getBytes("UTF-8");
        this.in = in;
        this.checkMagic();
    }

    public BytesChunkReader(byte[] magicBytes, InputStream in) throws IOException {
        this.magicBytes = magicBytes;
        this.in = in;
        this.checkMagic();
    }

    private void checkMagic() throws IOException {
        byte[] buff = new byte[this.magicBytes.length];
        int len = this.in.read(buff);
        if (len <= 0) {
            throw new IllegalDataException("No data to read!");
        }
        if (len < this.magicBytes.length) {
            throw new IllegalDataException("Mismatch magic bytes!");
        }
        if (!BytesUtils.equals(this.magicBytes, buff)) {
            throw new IllegalDataException("Mismatch magic bytes!");
        }
    }

    public byte[] read() throws IOException {
        int len = this.readNextLengthHeader();
        if (len < 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int reallyLen = BytesUtils.copy(this.in, out, len);
        if (reallyLen < len) {
            throw new IllegalDataException("No enough data as the length header indicated to read from the input stream !");
        }
        return out.toByteArray();
    }

    public int read(OutputStream out) throws IOException {
        int len = this.readNextLengthHeader();
        if (len < 0) {
            return -1;
        }
        int cpLen = BytesUtils.copy(this.in, out, len);
        if (cpLen < len) {
            throw new IllegalDataException("No enough data as the length header indicated to read from the input stream!");
        }
        return len;
    }

    private int readNextLengthHeader() throws IOException {
        int len = BytesUtils.readInt(this.in);
        if (len <= 0) {
            this.close();
            return -1;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] extract(byte[] magicBytes, byte[] compactedBytes) throws IOException {
        ArrayList<byte[]> dataBytesList;
        ByteArrayInputStream in = new ByteArrayInputStream(compactedBytes);
        try (BytesChunkReader reader = new BytesChunkReader(magicBytes, (InputStream)in);){
            dataBytesList = new ArrayList<byte[]>();
            byte[] dataBytes = null;
            while ((dataBytes = reader.read()) != null) {
                dataBytesList.add(dataBytes);
            }
        }
        return (byte[][])dataBytesList.toArray((T[])new byte[dataBytesList.size()][]);
    }
}

