/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import utils.io.BytesUtils;

public class BytesChunkWriter
implements Closeable {
    private static byte[] END_BYTES = BytesUtils.toBytes(-1);
    private byte[] magicBytes;
    private OutputStream out;
    private boolean enclose = false;

    public BytesChunkWriter(String magicString, OutputStream out) throws IOException {
        try {
            this.out = out;
            this.magicBytes = magicString.getBytes("UTF-8");
            this.writeMagic();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public BytesChunkWriter(byte[] magicBytes, OutputStream out) throws IOException {
        this.magicBytes = magicBytes;
        this.out = out;
        this.writeMagic();
    }

    private void writeMagic() throws IOException {
        if (this.magicBytes.length == 0) {
            throw new IllegalArgumentException("The magicBytes is empty!");
        }
        this.out.write(this.magicBytes);
    }

    public void write(byte[] bytes) throws IOException {
        this.checkEncosed();
        byte[] lenHeader = BytesUtils.toBytes(bytes.length);
        this.out.write(lenHeader);
        this.out.write(bytes);
    }

    public void write(int len, InputStream in) throws IOException {
        if (len < 1) {
            throw new IllegalArgumentException("The len must be positive!");
        }
        byte[] lenHeader = BytesUtils.toBytes(len);
        this.out.write(lenHeader);
        int wrLen = BytesUtils.copy(in, this.out, len);
        if (wrLen < len) {
            throw new IllegalArgumentException("The length of the input stream is less than the specified len of chunk!");
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void encloseChunk() throws IOException {
        if (this.enclose) {
            return;
        }
        this.out.write(END_BYTES);
        this.enclose = true;
    }

    private void checkEncosed() {
        if (this.enclose) {
            throw new IllegalStateException("This BytesChunkWriter instance is enclosed!");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.enclose) {
            this.encloseChunk();
            this.flush();
        }
        this.out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compact(byte[] magicBytes, byte[] ... dataBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BytesChunkWriter writer = new BytesChunkWriter(magicBytes, (OutputStream)out);){
            if (dataBytes != null) {
                for (byte[] bs : dataBytes) {
                    writer.write(bs);
                }
            }
            writer.flush();
        }
        return out.toByteArray();
    }
}

