/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import utils.ByteSequence;
import utils.Bytes;
import utils.IllegalDataException;
import utils.io.ByteArray;
import utils.io.BytesWriter;
import utils.io.RuntimeIOException;

public class BytesUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int MAX_BUFFER_SIZE = 0x40000000;
    public static final int BUFFER_SIZE = 64;
    public static final byte TRUE_BYTE = 1;
    public static final byte FALSE_BYTE = 0;

    private BytesUtils() {
    }

    public static boolean equals(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == bytes2) {
            return true;
        }
        if (bytes1 == null || bytes2 == null) {
            return false;
        }
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] bytes1, int offset1, byte[] bytes2, int offset2, int length) {
        if (bytes1 == bytes2) {
            return true;
        }
        if (bytes1 == null || bytes2 == null) {
            return false;
        }
        if (bytes1.length >= offset1 + length && bytes2.length >= offset2 + length) {
            for (int i = 0; i < length; ++i) {
                if (bytes1[offset1 + i] == bytes2[offset2 + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] toBytes(BytesWriter bytesWriter) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bytesWriter.writeTo(out);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static byte[] copyToBytes(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[64];
            int len = 0;
            long size = 0L;
            while ((len = in.read(buffer)) > 0) {
                if ((size += (long)len) > 0x40000000L) {
                    throw new IllegalArgumentException("The size of the InputStream exceed the max buffer size [1073741824]!");
                }
                out.write(buffer, 0, len);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return BytesUtils.copy(in, out, Integer.MAX_VALUE);
    }

    public static int copy(InputStream in, OutputStream out, int maxSize) throws IOException {
        int left;
        byte[] buffer = new byte[64];
        int len = 0;
        int readLen = buffer.length;
        for (left = maxSize; left > 0 && (len = in.read(buffer, 0, readLen = Math.min(left, buffer.length))) > 0; left -= len) {
            out.write(buffer, 0, len);
        }
        return maxSize - left;
    }

    public static byte[] toBytes(int value) {
        byte[] bytes = new byte[4];
        BytesUtils.toBytes(value, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(short value) {
        byte[] bytes = new byte[2];
        BytesUtils.toBytes(value, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(boolean value) {
        return new byte[]{value ? (byte)1 : 0};
    }

    public static byte[] toBytes(long value) {
        byte[] bytes = new byte[8];
        BytesUtils.toBytes(value, bytes, 0);
        return bytes;
    }

    public static void toBytes(short value, byte[] bytes) {
        BytesUtils.toBytes(value, bytes, 0);
    }

    public static int toBytes(int value, byte[] bytes) {
        return BytesUtils.toBytes(value, bytes, 0);
    }

    public static int toBytes(int value, byte[] bytes, int offset) {
        return BytesUtils.toBytes_BigEndian(value, bytes, offset);
    }

    public static int toBytes_BigEndian(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(value >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(value >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(value & 0xFF);
        return 4;
    }

    public static int toBytes_LittleEndian(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFF);
        bytes[offset + 1] = (byte)(value >>> 8 & 0xFF);
        bytes[offset + 2] = (byte)(value >>> 16 & 0xFF);
        bytes[offset + 3] = (byte)(value >>> 24 & 0xFF);
        return 4;
    }

    public static int toBytesInReverse(int value, byte[] bytes, int offset) {
        return BytesUtils.toBytes_LittleEndian(value, bytes, offset);
    }

    public static int toBytesInReverse(int value, byte[] bytes, int offset, int len) {
        int i;
        int l;
        int n = l = len > 4 ? 4 : len;
        for (i = 0; i < l; ++i) {
            bytes[offset + i] = (byte)(value >>> 8 * i & 0xFF);
        }
        return i;
    }

    public static void toBytes(short value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value & 0xFF);
    }

    public static void toBytes_BigEndian(short value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value & 0xFF);
    }

    public static void toBytes(char value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value & 0xFF);
    }

    public static int toBytes(long value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value >>> 56 & 0xFFL);
        bytes[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        bytes[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        bytes[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        bytes[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        bytes[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        bytes[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        bytes[offset + 7] = (byte)(value & 0xFFL);
        return 8;
    }

    public static byte[] toBytes(String str) {
        return BytesUtils.toBytes(str, DEFAULT_CHARSET);
    }

    public static byte[] toBytes(String str, String charset) {
        if (null == str) {
            return null;
        }
        try {
            byte[] bytes = str.getBytes(charset);
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static String toString(byte[] bytes) {
        return BytesUtils.toString(bytes, DEFAULT_CHARSET);
    }

    public static String toString(byte[] bytes, int offset) {
        return BytesUtils.toString(bytes, offset, bytes.length - offset, DEFAULT_CHARSET);
    }

    public static String toString(byte[] bytes, int offset, int len) {
        return BytesUtils.toString(bytes, offset, len, DEFAULT_CHARSET);
    }

    public static String toString(byte[] bytes, String charset) {
        return BytesUtils.toString(bytes, 0, bytes.length, charset);
    }

    public static String toString(byte[] bytes, int offset, int len, String charset) {
        try {
            if (bytes == null) {
                return null;
            }
            if (len == 0) {
                return "";
            }
            return new String(bytes, offset, len, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static boolean toBoolean(byte value) {
        return value != 0;
    }

    public static int toInt(byte[] bytes) {
        return BytesUtils.toInt(bytes, 0);
    }

    public static short toShort(byte[] bytes, int offset) {
        short value = 0;
        value = (short)((value | bytes[offset] & 0xFF) << 8);
        value = (short)(value | bytes[offset + 1] & 0xFF);
        return value;
    }

    public static short toShort(byte[] bytes) {
        return BytesUtils.toShort(bytes, 0);
    }

    public static char toChar(byte[] bytes, int offset) {
        char value = '\u0000';
        value = (char)((value | bytes[offset] & 0xFF) << 8);
        value = (char)(value | bytes[offset + 1] & 0xFF);
        return value;
    }

    public static int toInt(byte[] bytes, int offset) {
        return BytesUtils.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int len) {
        return BytesUtils.toInt(bytes, offset, len, true);
    }

    public static int toInt(byte[] bytes, int offset, int len, boolean highAlign) {
        if (len < 1 || len > 4) {
            throw new IllegalArgumentException("Len less than 1 or greate than 4!");
        }
        int value = 0;
        if (highAlign) {
            for (int i = 0; i < len; ++i) {
                value |= (bytes[offset + i] & 0xFF) << 8 * (3 - i);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                value |= (bytes[offset + i] & 0xFF) << 8 * (len - 1 - i);
            }
        }
        return value;
    }

    public static long toLong(byte[] bytes) {
        return BytesUtils.toLong(bytes, 0);
    }

    public static long toLong(byte[] bytes, int offset) {
        long value = 0L;
        value = (value | (long)(bytes[offset] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 1] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 2] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 3] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 4] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 5] & 0xFF)) << 8;
        value = (value | (long)(bytes[offset + 6] & 0xFF)) << 8;
        return value |= (long)(bytes[offset + 7] & 0xFF);
    }

    public static short readShort(InputStream in) {
        try {
            int v = in.read();
            if (v < 0) {
                throw new IllegalDataException("No enough data to read as short from the specified input stream!");
            }
            int value = (v & 0xFF) << 8;
            v = in.read();
            if (v < 0) {
                throw new IllegalDataException("No enough data to read as short from the specified input stream!");
            }
            return (short)(value |= v & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int writeShort(short value, OutputStream out) {
        try {
            out.write(value >>> 8 & 0xFF);
            out.write(value & 0xFF);
            return 2;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int readInt(InputStream in) {
        try {
            int value = 0;
            int v0 = in.read();
            int v1 = in.read();
            int v2 = in.read();
            int v3 = in.read();
            if (v0 < 0 || v1 < 0 || v2 < 0 || v3 < 0) {
                throw new IllegalDataException("No enough data to read as integer from the specified input stream!");
            }
            value = v0 << 24 | v1 << 16 | v2 << 8 | v3;
            return value;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int writeInt(int value, OutputStream out) {
        try {
            out.write(value >>> 24 & 0xFF);
            out.write(value >>> 16 & 0xFF);
            out.write(value >>> 8 & 0xFF);
            out.write(value & 0xFF);
            return 4;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static long readLong(InputStream in) {
        try {
            long value = 0L;
            for (int i = 0; i < 7; ++i) {
                int v = in.read();
                if (v < 0) {
                    throw new IllegalDataException("No enough data to read as long integer from the specified input stream!");
                }
                value = (value | (long)(v & 0xFF)) << 8;
            }
            return value |= (long)(in.read() & 0xFF);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int writeLong(long value, OutputStream out) {
        try {
            out.write((int)(value >>> 56 & 0xFFL));
            out.write((int)(value >>> 48 & 0xFFL));
            out.write((int)(value >>> 40 & 0xFFL));
            out.write((int)(value >>> 32 & 0xFFL));
            out.write((int)(value >>> 24 & 0xFFL));
            out.write((int)(value >>> 16 & 0xFFL));
            out.write((int)(value >>> 8 & 0xFFL));
            out.write((int)(value & 0xFFL));
            return 8;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static byte readByte(InputStream in) {
        try {
            int value = in.read();
            if (value < 0) {
                throw new IllegalDataException("No byte to read from the input stream!");
            }
            return (byte)value;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[64];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            outStream.close();
            return outStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeByte(byte value, OutputStream out) {
        try {
            out.write(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static byte[] concat(byte[] ... bytesList) {
        int size = 0;
        for (byte[] bs : bytesList) {
            size += bs.length;
        }
        byte[] bytesAll = new byte[size];
        size = 0;
        for (byte[] bs : bytesList) {
            System.arraycopy(bs, 0, bytesAll, size, bs.length);
            size += bs.length;
        }
        return bytesAll;
    }

    public static byte[] concat(Bytes ... bytesList) {
        int size = 0;
        for (Bytes bs : bytesList) {
            size += bs.size();
        }
        byte[] bytesAll = new byte[size];
        size = 0;
        for (Bytes bs : bytesList) {
            bs.copyTo(bytesAll, size, bs.size());
            size += bs.size();
        }
        return bytesAll;
    }

    public static byte[] concat(ByteSequence ... bytesList) {
        int size = 0;
        for (ByteSequence bs : bytesList) {
            size += bs.size();
        }
        byte[] bytesAll = new byte[size];
        size = 0;
        for (ByteSequence bs : bytesList) {
            size += bs.copyTo(bytesAll, size, bs.size());
        }
        return bytesAll;
    }

    public static char[] concat(char[] ... bytesList) {
        int size = 0;
        for (char[] bs : bytesList) {
            size += bs.length;
        }
        char[] bytesAll = new char[size];
        size = 0;
        for (char[] bs : bytesList) {
            System.arraycopy(bs, 0, bytesAll, size, bs.length);
            size += bs.length;
        }
        return bytesAll;
    }

    public static long toLong(ByteArray byteArray) {
        return BytesUtils.toLong(byteArray.bytes());
    }

    public static byte[] getBytesFromObject(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bo);
        oo.writeObject(obj);
        return bo.toByteArray();
    }

    public static boolean startsWith(byte[] srcBytes, byte[] prefixBytes) {
        for (int i = 0; i < prefixBytes.length; ++i) {
            if (prefixBytes[i] == srcBytes[i]) continue;
            return false;
        }
        return true;
    }
}

