/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.io.BytesInputStream;
import utils.io.BytesOutputBuffer;
import utils.io.BytesSlice;
import utils.io.RuntimeIOException;

public enum NumberMask {
    TINY(0),
    SHORT(1),
    NORMAL(2),
    LONG(3);

    public final byte BIT_COUNT;
    public final int MAX_HEADER_LENGTH;
    public final long MAX_BOUNDARY_SIZE;
    public final long BOUNDARY_SIZE_0;
    public final long BOUNDARY_SIZE_1;
    public final long BOUNDARY_SIZE_2;
    public final long BOUNDARY_SIZE_3;
    public final long BOUNDARY_SIZE_4;
    public final long BOUNDARY_SIZE_5;
    public final long BOUNDARY_SIZE_6;
    public final long BOUNDARY_SIZE_7;
    private long[] boundarySizes;

    private NumberMask(byte bitCount) {
        this.BIT_COUNT = bitCount;
        this.MAX_HEADER_LENGTH = 1 << bitCount;
        this.boundarySizes = new long[this.MAX_HEADER_LENGTH];
        for (int i = 0; i < this.MAX_HEADER_LENGTH; i = (int)((byte)(i + 1))) {
            this.boundarySizes[i] = this.computeBoundarySize((byte)(i + 1));
        }
        this.MAX_BOUNDARY_SIZE = this.boundarySizes[this.MAX_HEADER_LENGTH - 1];
        if (bitCount == 0) {
            this.BOUNDARY_SIZE_0 = this.boundarySizes[0];
            this.BOUNDARY_SIZE_1 = -1L;
            this.BOUNDARY_SIZE_2 = -1L;
            this.BOUNDARY_SIZE_3 = -1L;
            this.BOUNDARY_SIZE_4 = -1L;
            this.BOUNDARY_SIZE_5 = -1L;
            this.BOUNDARY_SIZE_6 = -1L;
            this.BOUNDARY_SIZE_7 = -1L;
        } else if (bitCount == 1) {
            this.BOUNDARY_SIZE_0 = this.boundarySizes[0];
            this.BOUNDARY_SIZE_1 = this.boundarySizes[1];
            this.BOUNDARY_SIZE_2 = -1L;
            this.BOUNDARY_SIZE_3 = -1L;
            this.BOUNDARY_SIZE_4 = -1L;
            this.BOUNDARY_SIZE_5 = -1L;
            this.BOUNDARY_SIZE_6 = -1L;
            this.BOUNDARY_SIZE_7 = -1L;
        } else if (bitCount == 2) {
            this.BOUNDARY_SIZE_0 = this.boundarySizes[0];
            this.BOUNDARY_SIZE_1 = this.boundarySizes[1];
            this.BOUNDARY_SIZE_2 = this.boundarySizes[2];
            this.BOUNDARY_SIZE_3 = this.boundarySizes[3];
            this.BOUNDARY_SIZE_4 = -1L;
            this.BOUNDARY_SIZE_5 = -1L;
            this.BOUNDARY_SIZE_6 = -1L;
            this.BOUNDARY_SIZE_7 = -1L;
        } else if (bitCount == 3) {
            this.BOUNDARY_SIZE_0 = this.boundarySizes[0];
            this.BOUNDARY_SIZE_1 = this.boundarySizes[1];
            this.BOUNDARY_SIZE_2 = this.boundarySizes[2];
            this.BOUNDARY_SIZE_3 = this.boundarySizes[3];
            this.BOUNDARY_SIZE_4 = this.boundarySizes[4];
            this.BOUNDARY_SIZE_5 = this.boundarySizes[5];
            this.BOUNDARY_SIZE_6 = this.boundarySizes[6];
            this.BOUNDARY_SIZE_7 = this.boundarySizes[7];
        } else {
            throw new IllegalArgumentException("Illegal bitCount!");
        }
    }

    public long getBoundarySize(int headerLength) {
        return this.boundarySizes[headerLength - 1];
    }

    private long computeBoundarySize(int headerLength) {
        long boundarySize = 1L << headerLength * 8 - this.BIT_COUNT;
        return boundarySize;
    }

    public int getMaskLength(long number) {
        if (number > -1L) {
            if (number < this.BOUNDARY_SIZE_0) {
                return 1;
            }
            if (number < this.BOUNDARY_SIZE_1) {
                return 2;
            }
            if (number < this.BOUNDARY_SIZE_2) {
                return 3;
            }
            if (number < this.BOUNDARY_SIZE_3) {
                return 4;
            }
            if (number < this.BOUNDARY_SIZE_4) {
                return 5;
            }
            if (number < this.BOUNDARY_SIZE_5) {
                return 6;
            }
            if (number < this.BOUNDARY_SIZE_6) {
                return 7;
            }
            if (number < this.BOUNDARY_SIZE_7) {
                return 8;
            }
        }
        throw new IllegalArgumentException("Number is out of the illegal range! --[number=" + number + "]");
    }

    public byte[] generateMask(long number) {
        int maskLen = this.getMaskLength(number);
        byte[] maskBytes = new byte[maskLen];
        this.writeMask(number, maskLen, maskBytes, 0);
        return maskBytes;
    }

    public int writeMask(long number, byte[] buffer, int offset) {
        int maskLen = this.getMaskLength(number);
        return this.writeMask(number, maskLen, buffer, offset);
    }

    private int writeMask(long number, int maskLen, byte[] buffer, int offset) {
        for (int i = maskLen; i > 0; --i) {
            buffer[offset + i - 1] = (byte)(number >>> 8 * (maskLen - i) & 0xFFL);
        }
        byte indicatorByte = (byte)(maskLen - 1 << 8 - this.BIT_COUNT);
        buffer[offset] = (byte)(indicatorByte | buffer[offset]);
        return maskLen;
    }

    public int writeMask(long number, OutputStream out) {
        byte[] maskBytes = this.generateMask(number);
        try {
            out.write(maskBytes);
            return maskBytes.length;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public int writeMask(long number, BytesOutputBuffer out) {
        byte[] maskBytes = this.generateMask(number);
        out.write(maskBytes);
        return maskBytes.length;
    }

    public int resolveMaskLength(BytesSlice bytes) {
        return this.resolveMaskLength(bytes.getByte());
    }

    public int resolveMaskLength(BytesSlice bytes, int offset) {
        return this.resolveMaskLength(bytes.getByte(offset));
    }

    public int resolveMaskLength(byte headByte) {
        int len = ((headByte & 0xFF) >>> 8 - this.BIT_COUNT) + 1;
        if (len < 1) {
            throw new IllegalArgumentException("Illegal length [" + len + "] was resolved from the head byte of NumberMask!");
        }
        if (len > this.MAX_HEADER_LENGTH) {
            throw new IllegalArgumentException("Illegal length [" + len + "] was resolved from the head byte of NumberMask!");
        }
        return len;
    }

    public long resolveMaskedNumber(byte[] markBytes) {
        return this.resolveMaskedNumber(markBytes, 0);
    }

    public long resolveMaskedNumber(byte[] markBytes, int offset) {
        int maskLen = this.resolveMaskLength(markBytes[offset]);
        byte numberHead = (byte)(markBytes[offset] & 255 >>> this.BIT_COUNT);
        long number = numberHead & 0xFF;
        for (int i = 1; i < maskLen; ++i) {
            number = number << 8 | (long)(markBytes[offset + i] & 0xFF);
        }
        return number;
    }

    public long resolveMaskedNumber(BytesSlice bytes) {
        return this.resolveMaskedNumber(bytes, 0);
    }

    public long resolveMaskedNumber(BytesSlice bytes, int offset) {
        byte headByte = bytes.getByte(offset);
        int maskLen = this.resolveMaskLength(headByte);
        byte numberHead = (byte)(headByte & 255 >>> this.BIT_COUNT);
        long number = numberHead & 0xFF;
        for (int i = 1; i < maskLen; ++i) {
            number = number << 8 | (long)(bytes.getByte(offset + i) & 0xFF);
        }
        return number;
    }

    public long resolveMaskedNumber(BytesInputStream bytesStream) {
        byte headByte = bytesStream.readByte();
        int maskLen = this.resolveMaskLength(headByte);
        byte numberHead = (byte)(headByte & 255 >>> this.BIT_COUNT);
        long number = numberHead & 0xFF;
        for (int i = 1; i < maskLen; ++i) {
            number = number << 8 | (long)(bytesStream.readByte() & 0xFF);
        }
        return number;
    }

    public long resolveMaskedNumber(InputStream in) {
        try {
            byte[] buff = new byte[this.MAX_HEADER_LENGTH];
            int len = in.read(buff, 0, 1);
            if (len < 1) {
                throw new IllegalArgumentException("No enough bytes for the size header's indicator byte!");
            }
            int maskLen = this.resolveMaskLength(buff[0]);
            if (maskLen > 1) {
                in.read(buff, 1, maskLen - 1);
            }
            return this.resolveMaskedNumber(buff, 0);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }
}

