/*
 * Decompiled with CFR 0.152.
 */
package utils.provider;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.provider.NamedProvider;
import utils.provider.Provider;
import utils.provider.ProviderException;

public final class ProviderManager {
    private final Logger LOGGER = LoggerFactory.getLogger(ProviderManager.class);
    private final Object mutex = new Object();
    private ConcurrentHashMap<Class<?>, NamedProviders<?>> serviceProviders = new ConcurrentHashMap();

    public <S> S getService(Class<S> serviceClazz, String providerName) {
        NamedProviders<S> providers = this.getNamedProviders(serviceClazz);
        return providers.getService(providerName);
    }

    public <S> Provider<S> getProvider(Class<S> serviceClazz, String providerName) {
        NamedProviders<?> providers = this.serviceProviders.get(serviceClazz);
        if (providers == null) {
            return null;
        }
        return providers.getProvider(providerName);
    }

    public <S> Collection<Provider<S>> getAllProviders(Class<S> serviceClazz) {
        NamedProviders<?> providers = this.serviceProviders.get(serviceClazz);
        if (providers == null) {
            return Collections.emptyList();
        }
        return providers.getProviders();
    }

    public <S> S installProvider(Class<S> serviceClazz, String providerFullName) {
        NamedProviders<S> providers = this.getNamedProviders(serviceClazz);
        return providers.install(providerFullName);
    }

    public <S> S installProvider(Class<S> service, String providerFullName, ClassLoader classLoader) {
        NamedProviders<S> providers = this.getNamedProviders(service);
        return providers.install(providerFullName, classLoader);
    }

    public <S> void installAllProviders(Class<S> serviceClazz, ClassLoader classLoader) {
        NamedProviders<S> providers = this.getNamedProviders(serviceClazz);
        providers.installAll(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> NamedProviders<S> getNamedProviders(Class<S> serviceClazz) {
        NamedProviders<Object> providers = this.serviceProviders.get(serviceClazz);
        if (providers == null) {
            Object object = this.mutex;
            synchronized (object) {
                providers = this.serviceProviders.get(serviceClazz);
                if (providers == null) {
                    providers = new NamedProviders<S>(serviceClazz);
                    this.serviceProviders.put(serviceClazz, providers);
                }
            }
        }
        return providers;
    }

    private static class ProviderInfo<S>
    implements Provider<S> {
        private final String shortName;
        private final String fullName;
        private final S service;

        public ProviderInfo(String shortName, String fullName, S service) {
            this.shortName = shortName;
            this.fullName = fullName;
            this.service = service;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public S getService() {
            return this.service;
        }
    }

    private class NamedProviders<S> {
        private Class<S> serviceClazz;
        private Map<String, String> shortNames = new HashMap<String, String>();
        private Map<String, Provider<S>> namedProviders = new LinkedHashMap<String, Provider<S>>();
        private AccessControlContext acc;

        public NamedProviders(Class<S> serviceClazz) {
            this.serviceClazz = serviceClazz;
            this.acc = System.getSecurityManager() != null ? AccessController.getContext() : null;
            this.installAll();
        }

        public void installAll(ClassLoader classLoader) {
            ServiceLoader<S> sl = ServiceLoader.load(this.serviceClazz, classLoader);
            this.installAll(sl);
        }

        public void installAll() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.installAll(classLoader);
        }

        private synchronized void installAll(ServiceLoader<S> sl) {
            for (S provider : sl) {
                this.install(provider);
            }
        }

        private synchronized boolean install(S service) {
            String n;
            String fullName = service.getClass().getName();
            if (this.namedProviders.containsKey(fullName)) {
                ProviderManager.this.LOGGER.warn(String.format("The provider[%s] already exists.", fullName));
                return false;
            }
            String shortName = null;
            NamedProvider annoNP = service.getClass().getAnnotation(NamedProvider.class);
            if (annoNP != null && annoNP.value() != null && (n = annoNP.value().trim()).length() > 0) {
                shortName = n;
            }
            if (shortName != null && this.shortNames.containsKey(shortName)) {
                return false;
            }
            ProviderInfo<S> provider = new ProviderInfo<S>(shortName, fullName, service);
            if (shortName != null) {
                this.shortNames.put(shortName, fullName);
            }
            this.namedProviders.put(fullName, provider);
            return true;
        }

        public S install(String providerFullName) {
            return this.install(providerFullName, null);
        }

        public S install(final String providerFullName, ClassLoader classLoader) {
            final ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
            S p = null;
            if (this.acc == null) {
                p = this.instantiate(providerFullName, cl);
            } else {
                PrivilegedAction action = new PrivilegedAction<S>(){

                    @Override
                    public S run() {
                        return NamedProviders.this.instantiate(providerFullName, cl);
                    }
                };
                p = (S)AccessController.doPrivileged(action, this.acc);
            }
            if (!this.install(p)) {
                throw new ProviderException("[" + this.serviceClazz.getName() + "] Provider " + providerFullName + " already exist!");
            }
            return p;
        }

        public Collection<Provider<S>> getProviders() {
            return this.namedProviders.values();
        }

        public Provider<S> getProvider(String providerFullName) {
            return this.namedProviders.get(providerFullName);
        }

        public S getService(String name) {
            Provider<S> pd;
            String fullName = this.shortNames.get(name);
            if (fullName == null) {
                fullName = name;
            }
            return (pd = this.namedProviders.get(fullName)) == null ? null : (S)pd.getService();
        }

        private S instantiate(String className, ClassLoader classLoader) {
            Class<?> c = null;
            try {
                c = Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException x) {
                throw new ProviderException("[" + this.serviceClazz.getName() + "] Provider " + className + " not found");
            }
            if (!this.serviceClazz.isAssignableFrom(c)) {
                throw new ProviderException("[" + this.serviceClazz.getName() + "] Provider " + className + " not a subtype");
            }
            try {
                S provider = this.serviceClazz.cast(c.newInstance());
                return provider;
            }
            catch (Throwable e) {
                throw new ProviderException("[" + this.serviceClazz.getName() + "] Provider " + className + " could not be instantiated! --" + e.getMessage());
            }
        }
    }
}

