/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArgumentSet {
    private ArgEntry[] args;
    private Map<String, ArgEntry> prefixArgs = new HashMap<String, ArgEntry>();
    private Set<String> options = new HashSet<String>();

    private ArgumentSet(ArgEntry[] args) {
        this.args = args;
        for (ArgEntry arg : args) {
            if (arg.prefix != null) {
                this.prefixArgs.put(arg.prefix, arg);
            }
            if (arg.option == null) continue;
            this.options.add(arg.option);
        }
    }

    public static boolean hasOption(String[] args, String option) {
        boolean contains = false;
        if (args != null) {
            for (String a : args) {
                if (!option.equalsIgnoreCase(a)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static Setting setting() {
        return new Setting();
    }

    public static ArgumentSet resolve(String[] args, Setting setting) {
        if (args == null) {
            return new ArgumentSet(new ArgEntry[0]);
        }
        ArrayList<ArgEntry> argEntries = new ArrayList<ArgEntry>();
        for (int i = 0; i < args.length; ++i) {
            ArgEntry ae;
            if (setting.prefixes.contains(args[i])) {
                ae = new ArgEntry();
                ae.prefix = args[i];
                if (i + 1 >= args.length) {
                    throw new IllegalArgumentException(String.format("\u7f3a\u5c11 %s \u53c2\u6570\uff01", args[i]));
                }
                ae.value = args[++i];
                argEntries.add(ae);
                continue;
            }
            if (!setting.options.contains(args[i])) continue;
            ae = new ArgEntry();
            ae.option = args[i];
            argEntries.add(ae);
        }
        return new ArgumentSet(argEntries.toArray(new ArgEntry[argEntries.size()]));
    }

    public ArgEntry[] getArgs() {
        return this.args;
    }

    public ArgEntry getArg(String prefix) {
        return this.prefixArgs.get(prefix);
    }

    public boolean hasOption(String option) {
        return this.options.contains(option);
    }

    public static class Setting {
        private Set<String> prefixes = new HashSet<String>();
        private Set<String> options = new HashSet<String>();

        private Setting() {
        }

        public Setting prefix(String ... prefixes) {
            this.prefixes.addAll(Arrays.asList(prefixes));
            return this;
        }

        public Setting option(String ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }
    }

    public static class ArgEntry {
        private String prefix;
        private String value;
        private String option;

        public String getPrefix() {
            return this.prefix;
        }

        public String getValue() {
            return this.value;
        }

        public String getOption() {
            return this.option;
        }
    }
}

