/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import utils.ArrayIterator;
import utils.ReadonlyArrayListWrapper;

public abstract class ArrayUtils {
    private ArrayUtils() {
    }

    public static long sum(long[] array) {
        long sum = 0L;
        for (long c : array) {
            sum += c;
        }
        return sum;
    }

    public static long sum(long[] array, int from, int to) {
        long sum = 0L;
        for (int i = from; i < to && i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static long[] concat(long[] array1, long[] array2) {
        long[] newArray = (long[])Array.newInstance(Long.TYPE, array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static <T> T[] concat(T[] array1, T[] array2, Class<T> clazz) {
        Object[] newArray = (Object[])Array.newInstance(clazz, array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static <T> T[] concat(T[] array1, T newElement, Class<T> clazz) {
        Object[] newArray = (Object[])Array.newInstance(clazz, array1.length + 1);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        newArray[array1.length] = newElement;
        return newArray;
    }

    public static <T, R> R[] cast(T[] objs, Class<R> clazz, CastFunction<T, R> cf) {
        if (objs == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(clazz, objs.length);
        for (int i = 0; i < objs.length; ++i) {
            array[i] = cf.cast(objs[i]);
        }
        return array;
    }

    public static <T> T[] singleton(T obj, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, 1);
        array[0] = obj;
        return array;
    }

    public static <T> T[] toArray(Iterator<T> itr, Class<T> clazz) {
        LinkedList<T> lst = new LinkedList<T>();
        while (itr.hasNext()) {
            T t = itr.next();
            lst.add(t);
        }
        Object[] array = (Object[])Array.newInstance(clazz, lst.size());
        lst.toArray(array);
        return array;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, collection.size());
        collection.toArray(array);
        return array;
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new ArrayIterator<T>(array);
    }

    public static <T> List<T> asUnmodifiableList(T[] array) {
        return ArrayUtils.asUnmodifiableList(array, 0, array.length);
    }

    public static <T> Set<T> mergeToSet(T[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptySet();
        }
        HashSet<T> set = new HashSet<T>();
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static <T> SortedSet<T> mergeToSortedSet(T[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptySortedSet();
        }
        TreeSet<T> set = new TreeSet<T>();
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static <T> List<T> asUnmodifiableList(T[] array, int fromIndex) {
        return ArrayUtils.asUnmodifiableList(array, fromIndex, array.length);
    }

    public static <T> List<T> asUnmodifiableList(T[] array, int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException("The toIndex less than fromIndex!");
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException("The fromIndex is negative!");
        }
        if (toIndex > array.length) {
            throw new IllegalArgumentException("The toIndex great than the length of array!");
        }
        if (fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return new ReadonlyArrayListWrapper<T>(array, fromIndex, toIndex);
    }

    public static <T> void reverse(T[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            T t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static void reverse(long[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            long t = array[i];
            array[i] = array[j];
            array[j] = t;
        }
    }

    public static boolean equals(int[] array0, int[] array1) {
        if (array0 == array1) {
            return true;
        }
        if (array0 == null || array1 == null) {
            return false;
        }
        if (array0.length != array1.length) {
            return false;
        }
        for (int i = 0; i < array0.length; ++i) {
            if (array0[i] == array1[i]) continue;
            return false;
        }
        return true;
    }

    public static interface CastFunction<T, R> {
        public R cast(T var1);
    }
}

