/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.springframework.util.StringUtils;

public abstract class PathUtils {
    public static final String PATH_SEPERATOR = "/";
    public static final char PATH_SEPERATOR_CHAR = '/';
    public static final String WINDOWS_PATH_SEPERATOR = "\\";
    public static final String SCHEMA_SEPERATOR = ":";

    public static String standardize(String path) {
        path = StringUtils.trimAllWhitespace((String)path);
        path = StringUtils.cleanPath((String)path);
        if ((path = PathUtils.cleanRepeatlySeperator(path)).endsWith(PATH_SEPERATOR)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String absolute(String path) {
        if (path.startsWith(PATH_SEPERATOR)) {
            return path;
        }
        if (path.indexOf(SCHEMA_SEPERATOR) >= 0) {
            return path;
        }
        return PATH_SEPERATOR + path;
    }

    public static String cleanRepeatlySeperator(String path) {
        String schema = "";
        String pathToProcess = path;
        int index = path.indexOf("://");
        if (index >= 0) {
            schema = path.substring(0, index + 3);
            index += 3;
            while (index < path.length() && path.charAt(index) == '/') {
                ++index;
            }
            pathToProcess = path.substring(index);
        }
        StringBuilder pathToUse = new StringBuilder();
        boolean hit = false;
        for (int i = 0; i < pathToProcess.length(); ++i) {
            char ch = pathToProcess.charAt(i);
            if (ch == '/') {
                if (hit) continue;
                hit = true;
            } else {
                hit = false;
            }
            pathToUse.append(ch);
        }
        return schema + pathToUse;
    }

    public static String concatPaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (String p : paths) {
            path.append(p);
            path.append('/');
        }
        return PathUtils.standardize(path.toString());
    }
}

