/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import utils.Property;

public abstract class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static <T> T createInstance(Class<T> configClass, Properties properties) {
        BeanWrapperImpl confBean = new BeanWrapperImpl(configClass);
        confBean.setAutoGrowNestedPaths(true);
        MutablePropertyValues values = new MutablePropertyValues((Map)properties);
        confBean.setPropertyValues((PropertyValues)values, true);
        return (T)confBean.getWrappedInstance();
    }

    public static <T> T createInstance(Class<T> configClass, Properties properties, String propsPrefix) {
        if (propsPrefix == null || propsPrefix.trim().length() == 0) {
            return PropertiesUtils.createInstance(configClass, properties);
        }
        propsPrefix = propsPrefix.trim();
        Properties configProperties = PropertiesUtils.subset(properties, propsPrefix, true);
        return PropertiesUtils.createInstance(configClass, configProperties);
    }

    public static void setValues(Object obj, Properties configValues, String propPrefix) {
        Properties values = new Properties();
        PropertiesUtils.setValues(obj, values);
        PropertiesUtils.mergeFrom(configValues, values, propPrefix);
    }

    public static void setValues(Object obj, Properties configValues) {
        BeanWrapperImpl confBean = new BeanWrapperImpl(obj);
        confBean.setAutoGrowNestedPaths(true);
        MutablePropertyValues values = new MutablePropertyValues((Map)configValues);
        confBean.setPropertyValues((PropertyValues)values, true);
    }

    public static <T> T load(Class<T> configClass, String configFilePathPattern, String charset) throws IOException {
        Properties props = PropertiesUtils.loadProperties(configFilePathPattern, charset);
        return PropertiesUtils.createInstance(configClass, props);
    }

    public static void load(Object obj, String configFilePathPattern, String charset) throws IOException {
        Properties props = PropertiesUtils.loadProperties(configFilePathPattern, charset);
        PropertiesUtils.setValues(obj, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String configFilePathPattern, String charset) throws IOException {
        PathMatchingResourcePatternResolver resResolver = new PathMatchingResourcePatternResolver();
        Resource configResource = resResolver.getResource(configFilePathPattern);
        try (InputStream in = configResource.getInputStream();){
            Properties properties = PropertiesUtils.load(in, charset);
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File configFile, String charset) throws IOException {
        FileSystemResource resource = new FileSystemResource(configFile);
        try (InputStream in = resource.getInputStream();){
            Properties properties = PropertiesUtils.load(in, charset);
            return properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(InputStream in, String charset) throws IOException {
        Properties props = new Properties();
        try (InputStreamReader reader = new InputStreamReader(in, charset);){
            props.load(reader);
        }
        return props;
    }

    public static Properties load(byte[] bytes, String charset) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return PropertiesUtils.load(in, charset);
    }

    public static void mergeFrom(Properties props, Properties from) {
        PropertiesUtils.mergeFrom(props, from, null);
    }

    public static void mergeFrom(Properties props, Properties from, String propertyNamePrefix) {
        if (propertyNamePrefix == null || propertyNamePrefix.length() == 0) {
            for (String name : from.stringPropertyNames()) {
                props.setProperty(name, from.getProperty(name));
            }
        } else {
            for (String name : from.stringPropertyNames()) {
                props.setProperty(propertyNamePrefix + name, from.getProperty(name));
            }
        }
    }

    public static Properties subset(Properties props, String propertyNamePrefix, boolean trimPrefix) {
        Properties subProperties = new Properties();
        Set<String> names = props.stringPropertyNames();
        for (String name : names) {
            if (!name.startsWith(propertyNamePrefix)) continue;
            String newName = name;
            if (trimPrefix) {
                newName = name.substring(propertyNamePrefix.length());
            }
            subProperties.setProperty(newName, props.getProperty(name));
        }
        return subProperties;
    }

    public static Properties cloneFrom(Properties props) {
        Properties newProps = new Properties();
        Set<String> names = props.stringPropertyNames();
        for (String name : names) {
            newProps.setProperty(name, props.getProperty(name));
        }
        return newProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Properties props, String charsetName) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charsetName);){
                props.store(writer, null);
                writer.flush();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static int getInt(Properties props, String key) {
        String value = PropertiesUtils.getRequiredProperty(props, key);
        return Integer.parseInt(value);
    }

    public static int getIntOptional(Properties props, String key, int defaultValue) {
        String value = PropertiesUtils.getProperty(props, key, false);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean getBoolean(Properties props, String key) {
        String value = PropertiesUtils.getRequiredProperty(props, key);
        return Boolean.parseBoolean(value);
    }

    public static boolean getBooleanOptional(Properties props, String key, boolean defaultValue) {
        String value = PropertiesUtils.getProperty(props, key, false);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static String getRequiredProperty(Properties props, String key) {
        return PropertiesUtils.getProperty(props, key, true);
    }

    public static String getOptionalProperty(Properties props, String key) {
        return PropertiesUtils.getProperty(props, key, false);
    }

    public static String getOptionalProperty(Properties props, String key, String defaultValue) {
        String value = PropertiesUtils.getProperty(props, key, false);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getProperty(Properties props, String key, boolean required) {
        String value = props.getProperty(key);
        if (value == null) {
            if (required) {
                throw new IllegalArgumentException("Miss property[" + key + "]!");
            }
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            if (required) {
                throw new IllegalArgumentException("Miss property[" + key + "]!");
            }
            return null;
        }
        return value;
    }

    public static Property[] getOrderedValues(Properties props) {
        Property[] values = new Property[props.size()];
        String[] propNames = props.stringPropertyNames().toArray(new String[props.size()]);
        Arrays.sort(propNames, (n1, n2) -> n1.compareTo((String)n2));
        for (int i = 0; i < propNames.length; ++i) {
            values[i] = new Property(propNames[i], props.getProperty(propNames[i]));
        }
        return values;
    }

    public static Properties createProperties(Property[] propValues) {
        Properties props = new Properties();
        PropertiesUtils.setValues(props, propValues);
        return props;
    }

    public static Properties setValues(Properties props, Property[] propValues) {
        for (Property p : propValues) {
            props.setProperty(p.getName(), p.getValue());
        }
        return props;
    }
}

