/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.reflect.Array;
import java.util.Iterator;
import utils.Mapper;

public interface SkippingIterator<E>
extends Iterator<E> {
    public long getTotalCount();

    public long getCursor();

    default public long getCount() {
        return this.getTotalCount() - this.getCursor() - 1L;
    }

    public long skip(long var1);

    default public E[] next(int maxCount, Class<E> clazz) {
        int count = (int)Math.min(this.getCount(), (long)maxCount);
        Object[] datas = (Object[])Array.newInstance(clazz, count);
        this.next(datas, 0, count);
        return datas;
    }

    default public int next(E[] datas) {
        return this.next(datas, 0, datas.length);
    }

    default public int next(E[] datas, int offset) {
        return this.next(datas, 0, datas.length);
    }

    default public int next(E[] datas, int offset, int maxCount) {
        int count = (int)Math.min(this.getCount(), (long)maxCount);
        for (int i = 0; i < count && this.hasNext(); ++i) {
            datas[i] = this.next();
        }
        return count;
    }

    default public <T> T[] next(int maxCount, Class<T> clazz, Mapper<E, T> mapper) {
        int count = (int)Math.min(this.getCount(), (long)maxCount);
        Object[] datas = (Object[])Array.newInstance(clazz, count);
        this.next(datas, 0, count, mapper);
        return datas;
    }

    default public <T> int next(T[] datas, Mapper<E, T> mapper) {
        return this.next(datas, 0, datas.length, mapper);
    }

    default public <T> int next(T[] datas, int offset, Mapper<E, T> mapper) {
        return this.next(datas, 0, datas.length, mapper);
    }

    default public <T> int next(T[] datas, int offset, int maxCount, Mapper<E, T> mapper) {
        int count = (int)Math.min(this.getCount(), (long)maxCount);
        for (int i = 0; i < count && this.hasNext(); ++i) {
            datas[i] = mapper.from(this.next());
        }
        return count;
    }

    default public <T> SkippingIterator<T> iterateAs(final Mapper<E, T> mapper) {
        final SkippingIterator source = this;
        return new SkippingIterator<T>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public T next() {
                return mapper.from(source.next());
            }

            @Override
            public long getTotalCount() {
                return source.getTotalCount();
            }

            @Override
            public long getCursor() {
                return source.getCursor();
            }

            @Override
            public long skip(long count) {
                return source.skip(count);
            }
        };
    }
}

