/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static Pattern NUMBER_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static boolean isNumber(String str) {
        return NUMBER_PATTERN.matcher(str).matches();
    }

    public static String[] splitToArray(String str, String delimiter) {
        return StringUtils.splitToArray(str, delimiter, true, true);
    }

    public static String[] splitToArray(String str, String delimiter, boolean trimElement, boolean ignoreEmptyElement) {
        if (str == null) {
            return EMPTY_ARRAY;
        }
        if (trimElement) {
            str = str.trim();
        }
        if (str.length() == 0) {
            return EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trimElement) {
                token = token.trim();
            }
            if (ignoreEmptyElement && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }
}

