/*
 * Decompiled with CFR 0.152.
 */
package utils.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import utils.concurrent.AsyncFuture;
import utils.concurrent.AsyncHandle;
import utils.concurrent.RuntimeExecutionException;
import utils.concurrent.RuntimeInterruptedException;
import utils.concurrent.RuntimeTimeoutException;

public class CompletableAsyncFuture<T>
implements AsyncFuture<T> {
    private CompletableFuture<T> cf;

    public CompletableAsyncFuture() {
        this.cf = new CompletableFuture();
    }

    private CompletableAsyncFuture(CompletableFuture<T> cf) {
        this.cf = cf;
    }

    public static <T> CompletableAsyncFuture<T> completeFuture(T value) {
        CompletableFuture<T> cf = CompletableFuture.completedFuture(value);
        return new CompletableAsyncFuture<T>(cf);
    }

    public static CompletableAsyncFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> cf = CompletableFuture.runAsync(runnable);
        return new CompletableAsyncFuture<Void>(cf);
    }

    public static CompletableAsyncFuture<Void> runAsync(Runnable runnable, Executor executor) {
        CompletableFuture<Void> cf = CompletableFuture.runAsync(runnable, executor);
        return new CompletableAsyncFuture<Void>(cf);
    }

    public static <T> CompletableAsyncFuture<T> callAsync(final Callable<T> callable) {
        CompletableFuture cf = CompletableFuture.supplyAsync(new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeExecutionException(e.getMessage(), e);
                }
            }
        });
        return new CompletableAsyncFuture(cf);
    }

    public static <T> CompletableAsyncFuture<T> callAsync(final Callable<T> callable, Executor executor) {
        CompletableFuture cf = CompletableFuture.supplyAsync(new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeExecutionException(e.getMessage(), e);
                }
            }
        }, executor);
        return new CompletableAsyncFuture(cf);
    }

    public static <T> CompletableAsyncFuture<T> callAsync(Supplier<T> supplier) {
        CompletableFuture<T> cf = CompletableFuture.supplyAsync(supplier);
        return new CompletableAsyncFuture<T>(cf);
    }

    public static <T> CompletableAsyncFuture<T> callAsync(Supplier<T> supplier, Executor executor) {
        CompletableFuture<T> cf = CompletableFuture.supplyAsync(supplier, executor);
        return new CompletableAsyncFuture<T>(cf);
    }

    public boolean complete(T value) {
        return this.cf.complete(value);
    }

    public boolean error(Throwable ex) {
        return this.cf.completeExceptionally(ex);
    }

    @Override
    public T get() {
        try {
            return this.cf.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new RuntimeExecutionException(cause.getMessage(), cause);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        try {
            return this.cf.get(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new RuntimeExecutionException(cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new RuntimeTimeoutException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isDone() {
        return this.cf.isDone();
    }

    @Override
    public boolean isExceptionally() {
        return this.cf.isCompletedExceptionally();
    }

    @Override
    public AsyncFuture<T> thenAccept(Consumer<? super T> action) {
        this.cf.thenAccept((Consumer)action);
        return this;
    }

    @Override
    public AsyncFuture<T> thenAcceptAsync(Consumer<? super T> action) {
        this.cf.thenAcceptAsync((Consumer)action);
        return this;
    }

    @Override
    public AsyncFuture<T> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        this.cf.thenAcceptAsync((Consumer)action, executor);
        return this;
    }

    @Override
    public AsyncFuture<T> thenRun(Runnable action) {
        this.cf.thenRun(action);
        return this;
    }

    @Override
    public AsyncFuture<T> thenRunAsync(Runnable action) {
        this.cf.thenRunAsync(action);
        return this;
    }

    @Override
    public AsyncFuture<T> thenRunAsync(Runnable action, Executor executor) {
        this.cf.thenRunAsync(action, executor);
        return this;
    }

    @Override
    public AsyncFuture<T> whenComplete(AsyncHandle<? super T> action) {
        this.cf.whenComplete((BiConsumer)action);
        return this;
    }

    @Override
    public AsyncFuture<T> whenCompleteAsync(AsyncHandle<? super T> action) {
        this.cf.whenCompleteAsync((BiConsumer)action);
        return this;
    }

    @Override
    public AsyncFuture<T> whenCompleteAsync(AsyncHandle<? super T> action, Executor executor) {
        this.cf.whenCompleteAsync((BiConsumer)action, executor);
        this.cf.whenCompleteAsync((T a, U b) -> action.accept((Object)a, (Throwable)b), executor);
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cf.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.cf.isCancelled();
    }
}

