/*
 * Decompiled with CFR 0.152.
 */
package utils.concurrent;

public abstract class ThreadInvoker<T> {
    private volatile T retn;
    private volatile Exception error;
    private volatile boolean started = false;

    public Exception getError() {
        return this.error;
    }

    public T getRetn() {
        return this.retn;
    }

    protected abstract T invoke() throws Exception;

    public T startAndWait() {
        Thread thrd = this.doStart();
        try {
            thrd.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (this.error != null) {
            throw new IllegalStateException(this.error.getMessage(), this.error);
        }
        return this.retn;
    }

    public AsyncCallback<T> start() {
        Thread thrd = this.doStart();
        return new AsyncCallback(thrd, this);
    }

    public synchronized void reset() {
        if (this.started) {
            throw new IllegalStateException("Cann't reset when this invoking is running.");
        }
        this.retn = null;
        this.error = null;
    }

    private synchronized Thread doStart() {
        if (this.started) {
            throw new IllegalStateException("Invoker thread has started. Cann't start again until it's over.");
        }
        if (this.retn != null || this.error != null) {
            throw new IllegalStateException("Cann't start again until the result of last invoking is reseted.");
        }
        this.started = true;
        Thread thrd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadInvoker.this.retn = ThreadInvoker.this.invoke();
                }
                catch (Exception e) {
                    ThreadInvoker.this.error = e;
                }
                finally {
                    ThreadInvoker.this.started = false;
                }
            }
        });
        thrd.start();
        return thrd;
    }

    public static class AsyncCallback<T> {
        private Thread thrd;
        private ThreadInvoker<T> invoker;

        public AsyncCallback(Thread thrd, ThreadInvoker<T> invoker) {
            this.thrd = thrd;
            this.invoker = invoker;
        }

        public T waitReturn() {
            try {
                this.thrd.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (((ThreadInvoker)this.invoker).error != null) {
                throw new IllegalStateException(((ThreadInvoker)this.invoker).error.getMessage(), ((ThreadInvoker)this.invoker).error);
            }
            return (T)((ThreadInvoker)this.invoker).retn;
        }
    }
}

