/*
 * Decompiled with CFR 0.152.
 */
package utils.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import utils.console.CommondProcessor;

public class CommandConsole {
    private Map<String, CommondProcessor> processors = new ConcurrentHashMap<String, CommondProcessor>();
    private CommondProcessor defaultProcessor;
    private boolean monitoring = false;
    private BufferedReader in;
    private PrintStream out;
    private String prompt;
    private Logger logger = LoggerFactory.getLogger(CommandConsole.class);

    public PrintStream out() {
        return this.out;
    }

    public CommandConsole(InputStream input, PrintStream output, String prompt) {
        try {
            this.in = new BufferedReader(new InputStreamReader(input, "GBK"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.out = output;
        this.prompt = prompt;
        this.defaultProcessor = new CommondProcessor(){

            @Override
            public void onEnter(String command, String[] args, CommandConsole console) {
                console.out().println("Unsupported command [" + command + "]!");
            }
        };
    }

    public void setDefaultCommandProcessor(CommondProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Null argument!");
        }
        this.defaultProcessor = processor;
    }

    public synchronized void register(String command, CommondProcessor processor) {
        if (StringUtils.containsWhitespace((String)command)) {
            throw new IllegalArgumentException("Can't register command with white space character!");
        }
        if (this.processors.containsKey(command)) {
            throw new IllegalStateException("The command[" + command + "] has been registered!");
        }
        this.processors.put(command.toLowerCase(), processor);
    }

    public synchronized void open() {
        this.monitoring = true;
        while (this.monitoring) {
            String[] cmdArgs;
            String command;
            this.out.println();
            this.out.print(this.prompt);
            try {
                command = this.in.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (command == null || (cmdArgs = StringUtils.tokenizeToStringArray((String)command, (String)" ")).length == 0) continue;
            String cmd = cmdArgs[0];
            String[] args = cmdArgs.length > 1 ? Arrays.copyOfRange(cmdArgs, 1, cmdArgs.length) : new String[]{};
            CommondProcessor processor = this.processors.get(cmd.toLowerCase());
            try {
                if (processor != null) {
                    processor.onEnter(cmd, args, this);
                    continue;
                }
                this.defaultProcessor.onEnter(cmd, args, this);
            }
            catch (Exception e) {
                this.out.println("Error!!--" + e.getMessage());
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void close() {
        this.monitoring = false;
    }
}

