/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.io.ByteArray;
import utils.io.BytesUtils;
import utils.io.NumberMask;
import utils.io.RuntimeIOException;

public class BytesEncoding {
    public static int writeInNormal(byte[] data, OutputStream out) {
        return BytesEncoding.write(data, NumberMask.NORMAL, out);
    }

    public static int writeInShort(byte[] data, OutputStream out) {
        return BytesEncoding.write(data, NumberMask.SHORT, out);
    }

    public static int writeInTiny(byte[] data, OutputStream out) {
        return BytesEncoding.write(data, NumberMask.TINY, out);
    }

    public static int write(byte[] data, NumberMask dataLengthMask, OutputStream out) {
        try {
            int s = dataLengthMask.writeMask(data == null ? 0L : (long)data.length, out);
            if (data != null) {
                out.write(data, 0, data.length);
                s += data.length;
            }
            return s;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static int getOutputSizeInNormal(int dataSize) {
        return NumberMask.NORMAL.getMaskLength(dataSize) + dataSize;
    }

    public static int writeInNormal(byte[] data, byte[] buffer) {
        return BytesEncoding.write(NumberMask.NORMAL, data, 0, buffer, 0, data.length);
    }

    public static int writeInNormal(byte[] data, byte[] buffer, int bufferOffset) {
        return BytesEncoding.write(NumberMask.NORMAL, data, 0, buffer, bufferOffset, data.length);
    }

    public static int writeInNormal(byte[] data, byte[] buffer, int bufferOffset, int length) {
        return BytesEncoding.write(NumberMask.NORMAL, data, 0, buffer, bufferOffset, length);
    }

    public static int writeInNormal(byte[] data, int dataOffset, byte[] buffer, int bufferOffset, int length) {
        return BytesEncoding.write(NumberMask.NORMAL, data, dataOffset, buffer, bufferOffset, length);
    }

    public static int write(NumberMask dataLengthMask, byte[] data, byte[] buffer) {
        return BytesEncoding.write(dataLengthMask, data, 0, buffer, 0, data.length);
    }

    public static int write(NumberMask dataLengthMask, byte[] data, byte[] buffer, int bufferOffset) {
        return BytesEncoding.write(dataLengthMask, data, 0, buffer, bufferOffset, data.length);
    }

    public static int write(NumberMask dataLengthMask, byte[] data, byte[] buffer, int bufferOffset, int length) {
        return BytesEncoding.write(dataLengthMask, data, 0, buffer, bufferOffset, length);
    }

    public static int write(NumberMask dataLengthMask, byte[] data, int dataOffset, byte[] buffer, int bufferOffset, int length) {
        int s = dataLengthMask.writeMask(data == null ? 0L : (long)data.length, buffer, bufferOffset);
        bufferOffset += s;
        if (data != null) {
            System.arraycopy(data, dataOffset, buffer, bufferOffset, length);
            s += length;
        }
        return s;
    }

    public static byte[] readInTiny(byte[] buffer, int offset) {
        return BytesEncoding.read(NumberMask.TINY, buffer, offset);
    }

    public static byte[] readInShort(byte[] buffer, int offset) {
        return BytesEncoding.read(NumberMask.SHORT, buffer, offset);
    }

    public static byte[] readInNormal(byte[] buffer, int offset) {
        return BytesEncoding.read(NumberMask.NORMAL, buffer, offset);
    }

    public static byte[] read(NumberMask dataLengthMask, byte[] buffer, int offset) {
        int size = (int)dataLengthMask.resolveMaskedNumber(buffer, offset);
        int maskLen = dataLengthMask.resolveMaskLength(buffer[offset]);
        byte[] data = new byte[size];
        System.arraycopy(buffer, offset += maskLen, data, 0, size);
        return data;
    }

    public static int write(ByteArray data, NumberMask dataLengthMask, OutputStream out) {
        int s = dataLengthMask.writeMask(data == null ? 0L : (long)data.size(), out);
        if (data != null) {
            s += data.writeTo(out);
        }
        return s;
    }

    public static byte[] readInTiny(InputStream in) {
        return BytesEncoding.read(NumberMask.TINY, in);
    }

    public static byte[] readInNormal(InputStream in) {
        return BytesEncoding.read(NumberMask.NORMAL, in);
    }

    public static byte[] readInShort(InputStream in) {
        return BytesEncoding.read(NumberMask.SHORT, in);
    }

    public static byte[] read(NumberMask dataLengthMask, InputStream in) {
        try {
            int size = (int)dataLengthMask.resolveMaskedNumber(in);
            if (size == 0) {
                return BytesUtils.EMPTY_BYTES;
            }
            byte[] data = new byte[size];
            int len = in.read(data, 0, size);
            if (len < size) {
                throw new IllegalArgumentException("No enough bytes was read as the size header indicated!");
            }
            return data;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }
}

