/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.IOException;
import java.io.InputStream;
import utils.io.BytesSlice;
import utils.io.BytesUtils;

public class BytesInputStream
extends InputStream {
    private byte[] bytes;
    private int posistion;
    private int tail;

    public BytesInputStream(byte[] bytes, int offset, int size) {
        this.bytes = bytes;
        this.posistion = offset;
        this.tail = offset + size;
    }

    protected int getPosition() {
        return this.posistion;
    }

    protected byte[] getOriginBytes() {
        return this.bytes;
    }

    public int getSize() {
        return this.tail - this.posistion;
    }

    public byte readByte() {
        int off = this.posistion++;
        this.checkBoundary(off, 1);
        return this.bytes[off];
    }

    public char readChar() {
        int off = this.posistion;
        this.checkBoundary(off, 2);
        char ch = BytesUtils.toChar(this.bytes, off);
        this.posistion += 2;
        return ch;
    }

    public short readShort() {
        int off = this.posistion;
        this.checkBoundary(off, 2);
        short n = BytesUtils.toShort(this.bytes, off);
        this.posistion += 2;
        return n;
    }

    public int readInt() {
        int off = this.posistion;
        this.checkBoundary(off, 4);
        int n = BytesUtils.toInt(this.bytes, off);
        this.posistion += 4;
        return n;
    }

    public long readLong() {
        int off = this.posistion;
        this.checkBoundary(off, 8);
        long n = BytesUtils.toLong(this.bytes, off);
        this.posistion += 8;
        return n;
    }

    public String readString(int size) {
        int off = this.posistion;
        this.checkBoundary(off, size);
        String s = BytesUtils.toString(this.bytes, off, size);
        this.posistion += size;
        return s;
    }

    public String readString(int size, String charset) {
        int off = this.posistion;
        this.checkBoundary(off, size);
        String s = BytesUtils.toString(this.bytes, off, size, charset);
        this.posistion += size;
        return s;
    }

    public byte[] readBytes(int size) {
        byte[] copy = new byte[size];
        this.readBytes(copy, 0, size);
        return copy;
    }

    public int readBytes(byte[] buffer, int offset, int size) {
        int off = this.posistion;
        int s = this.tail - this.posistion;
        s = s < size ? s : size;
        this.checkBoundary(off, s);
        System.arraycopy(this.bytes, off, buffer, offset, s);
        this.posistion += s;
        return s;
    }

    public BytesSlice getSlice() {
        if (this.tail == this.posistion) {
            return BytesSlice.EMPTY;
        }
        return this.getSlice(this.tail - this.posistion);
    }

    public BytesSlice getSlice(int size) {
        int off = this.posistion;
        this.checkBoundary(off, size);
        BytesSlice copy = new BytesSlice(this.bytes, off, size);
        return copy;
    }

    public BytesSlice readSlice(int size) {
        BytesSlice copy = this.getSlice(size);
        this.posistion += size;
        return copy;
    }

    public void skip(int size) {
        this.checkBoundary(this.posistion, size);
        this.posistion += size;
    }

    private void checkBoundary(int off, int len) {
        if (off < this.posistion || off + len > this.tail) {
            throw new IndexOutOfBoundsException("The accessing index is out of BytesInputStream's bounds!");
        }
    }

    @Override
    public int read() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        return this.getSize();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("Specified a negative number of bytes to be skipped!");
        }
        if (n >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The number of bytes to be skipped is out of max value!");
        }
        this.skip((int)n);
        return n;
    }
}

