/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.IOException;
import java.io.OutputStream;
import utils.io.RuntimeIOException;

public class BytesOutputBuffer {
    private static final int DEFAULT_CAPACITY = 8;
    private volatile int size = 0;
    private int capacity = 0;
    private int cursor = 0;
    private byte[][] buffers;

    public int getSize() {
        return this.size;
    }

    public BytesOutputBuffer() {
        this(8);
    }

    public BytesOutputBuffer(int initCapacity) {
        if (initCapacity < 0) {
            throw new IllegalArgumentException("Init capacity is negative!");
        }
        this.capacity = initCapacity;
        this.buffers = new byte[initCapacity][];
    }

    public synchronized void write(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null!");
        }
        int idx = this.cursor;
        if (idx == this.capacity) {
            this.growCapacity();
        }
        this.buffers[idx] = data;
        ++this.cursor;
        this.size += data.length;
    }

    private void growCapacity() {
        int newCapacity = this.capacity + this.capacity / 2;
        if (newCapacity == this.capacity) {
            ++newCapacity;
        }
        byte[][] newBuffers = new byte[newCapacity][];
        System.arraycopy(this.buffers, 0, newBuffers, 0, this.capacity);
        this.buffers = newBuffers;
        this.capacity = newCapacity;
    }

    public void write(BytesOutputBuffer buffer) {
        byte[][] fromBuffers = buffer.buffers;
        for (int i = 0; i < buffer.cursor; ++i) {
            this.write(fromBuffers[i]);
        }
    }

    public void writeCopy(byte[] data) {
        int len = data.length;
        byte[] copy = new byte[len];
        System.arraycopy(data, 0, copy, 0, len);
        this.write(copy);
    }

    public void writeCopy(byte[] data, int offset, int len) {
        byte[] copy = new byte[len];
        System.arraycopy(data, offset, copy, 0, len);
        this.write(copy);
    }

    public synchronized int writeTo(byte[] outBuffer, int offset) {
        int len;
        int t = len = Math.min(this.size, outBuffer.length - offset);
        int i = 0;
        while (i < this.cursor & t > 0) {
            int s = Math.min(this.buffers[i].length, t);
            System.arraycopy(this.buffers[i], 0, outBuffer, offset, s);
            offset += s;
            t -= s;
            ++i;
        }
        return len;
    }

    public synchronized int writeTo(OutputStream out) {
        try {
            for (int i = 0; i < this.cursor; ++i) {
                out.write(this.buffers[i]);
            }
            return this.size;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public byte[] toBytes() {
        byte[] data = new byte[this.size];
        this.writeTo(data, 0);
        return data;
    }
}

