/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import utils.ByteSequence;
import utils.io.BytesInputStream;
import utils.io.BytesSerializable;
import utils.io.BytesUtils;

public class BytesSlice
implements ByteSequence,
BytesSerializable {
    public static final BytesSlice EMPTY = new BytesSlice(new byte[0], 0, 0);
    private byte[] bytes;
    private int dataOffset;
    private int size;

    public BytesSlice() {
    }

    public BytesSlice(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public BytesSlice(byte[] bytes, int offset) {
        this(bytes, offset, bytes.length - offset);
    }

    public BytesSlice(byte[] bytes, int offset, int size) {
        if (offset + size > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes = bytes;
        this.dataOffset = offset;
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getSize() {
        return this.size;
    }

    public byte getByte() {
        return this.getByte(0);
    }

    public byte getByte(int offset) {
        int off = this.dataOffset + offset;
        this.checkBoundary(off, 1);
        return this.bytes[off];
    }

    public char getChar() {
        return this.getChar(0);
    }

    public char getChar(int offset) {
        int off = this.dataOffset + offset;
        this.checkBoundary(off, 2);
        return BytesUtils.toChar(this.bytes, off);
    }

    public short getShort() {
        return this.getShort(0);
    }

    public short getShort(int offset) {
        int off = this.dataOffset + offset;
        this.checkBoundary(off, 2);
        return BytesUtils.toShort(this.bytes, off);
    }

    public int getInt() {
        return this.getInt(0);
    }

    public int getInt(int offset) {
        int off = this.dataOffset + offset;
        this.checkBoundary(off, 4);
        return BytesUtils.toInt(this.bytes, off);
    }

    public long getLong() {
        return this.getLong(0);
    }

    public long getLong(int offset) {
        int off = this.dataOffset + offset;
        this.checkBoundary(off, 8);
        return BytesUtils.toLong(this.bytes, off);
    }

    public String getString() {
        return BytesUtils.toString(this.bytes, this.dataOffset, this.size);
    }

    public BytesInputStream getInputStream() {
        return this.getInputStream(0);
    }

    public BytesInputStream getInputStream(int offset) {
        int off = this.dataOffset + offset;
        int s = this.size;
        this.checkBoundary(off, s);
        return new BytesInputStream(this.bytes, off, s);
    }

    public byte[] getBytesCopy() {
        if (this.size == 0) {
            return BytesUtils.EMPTY_BYTES;
        }
        byte[] copy = new byte[this.size];
        System.arraycopy(this.bytes, this.dataOffset, copy, 0, this.size);
        return copy;
    }

    public byte[] getBytesCopy(int offset) {
        return this.getBytesCopy(offset, this.getSize() - offset);
    }

    public byte[] getBytesCopy(int offset, int size) {
        int newOffset = this.dataOffset + offset;
        this.checkBoundary(newOffset, size);
        if (size == 0) {
            return BytesUtils.EMPTY_BYTES;
        }
        byte[] copy = new byte[size];
        System.arraycopy(this.bytes, newOffset, copy, 0, size);
        return copy;
    }

    protected byte[] getOriginBytes() {
        return this.bytes;
    }

    protected int getOriginOffset() {
        return this.dataOffset;
    }

    protected void checkBoundary(int offset, int len) {
        if (offset < this.dataOffset || offset + len > this.dataOffset + this.size) {
            throw new IndexOutOfBoundsException("The accessing index is out of BytesSlice's bounds!");
        }
    }

    public BytesSlice getSlice(int offset) {
        return this.getSlice(offset, this.getSize() - offset);
    }

    public BytesSlice getSlice(int offset, int size) {
        int newOffset = this.dataOffset + offset;
        this.checkBoundary(newOffset, size);
        return new BytesSlice(this.bytes, newOffset, size);
    }

    public int copy(int srcOffset, byte[] dest, int destOffset, int size) {
        if (srcOffset < 0 || srcOffset >= this.size) {
            throw new IndexOutOfBoundsException("The argument \"srcOffset\" is out of BytesSlice's bounds!");
        }
        if (size < 0) {
            throw new IllegalArgumentException("The \"size\" argument is negative!");
        }
        int newOffset = this.dataOffset + srcOffset;
        int count = this.size - srcOffset;
        count = count < size ? count : size;
        System.arraycopy(this.bytes, newOffset, dest, destOffset, count);
        return count;
    }

    @Override
    public int copyTo(int srcOffset, byte[] dest, int destOffset, int length) {
        return this.copy(srcOffset, dest, destOffset, length);
    }

    @Override
    public byte[] toBytes() {
        return this.getBytesCopy();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte byteAt(int index) {
        return this.getByte(index);
    }

    @Override
    public boolean equal(byte[] data) {
        if (data.length != this.size()) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == this.bytes[this.dataOffset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        return this.getSlice(start, end - start);
    }
}

