/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import utils.io.BytesInputStream;
import utils.io.BytesSlice;
import utils.io.BytesSlices;
import utils.io.NumberMask;

public class DynamicBytesSliceArray
implements BytesSlices {
    private byte[] dataBytes;
    private int totalSize;
    private int[] offsets;
    private int[] sizes;

    private DynamicBytesSliceArray(byte[] dataBytes, int totalSize, int[] offsets, int[] sizes) {
        this.dataBytes = dataBytes;
        this.totalSize = totalSize;
        this.offsets = offsets;
        this.sizes = sizes;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getCount() {
        return this.sizes.length;
    }

    @Override
    public BytesSlice getDataSlice(int idx) {
        return new BytesSlice(this.dataBytes, this.offsets[idx], this.sizes[idx]);
    }

    public static BytesSlices resolve(BytesInputStream in) {
        int p1 = in.getPosition();
        int count = (int)NumberMask.NORMAL.resolveMaskedNumber(in);
        int[] offsets = new int[count];
        int[] sizes = new int[count];
        for (int i = 0; i < count; ++i) {
            int size;
            sizes[i] = size = (int)NumberMask.NORMAL.resolveMaskedNumber(in);
            offsets[i] = in.getPosition();
            in.skip(size);
        }
        int totalSize = in.getPosition() - p1;
        return new DynamicBytesSliceArray(in.getOriginBytes(), totalSize, offsets, sizes);
    }

    public static BytesSlices resolveNumbers(NumberMask numberMask, BytesInputStream in) {
        int p1 = in.getPosition();
        int count = (int)NumberMask.NORMAL.resolveMaskedNumber(in);
        int[] offsets = new int[count];
        int[] sizes = new int[count];
        for (int i = 0; i < count; ++i) {
            int size;
            offsets[i] = in.getPosition();
            byte headByte = in.readByte();
            sizes[i] = size = numberMask.resolveMaskLength(headByte);
            in.skip(size - 1);
        }
        int totalSize = in.getPosition() - p1;
        return new DynamicBytesSliceArray(in.getOriginBytes(), totalSize, offsets, sizes);
    }
}

