/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.ResourceUtils;
import utils.PathUtils;
import utils.io.BytesUtils;
import utils.io.RuntimeIOException;

public class FileUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static boolean existFile(String filePath) {
        File file = new File(filePath);
        return file.isFile();
    }

    public static boolean existDirectory(String dir) {
        File file = new File(dir);
        return file.isDirectory();
    }

    public static boolean makeDirectory(String dir) {
        File file = new File(dir);
        return file.mkdirs();
    }

    public static String getFullPath(String path) {
        try {
            File file = new File(path);
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static String getParent(String path) {
        File file = new File(path);
        return file.getParent();
    }

    public static String readFirstLine(File file) throws IOException {
        return FileUtils.readFirstLine(file, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFirstLine(File file, String charset) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
            String string = FileUtils.getFirstLine(reader);
            return string;
        }
    }

    public static String[] readLines(File file) {
        return FileUtils.readLines(file, DEFAULT_CHARSET);
    }

    /*
     * Exception decompiling
     */
    public static String[] readLines(File file, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeLines(String[] lines, File file) {
        FileUtils.writeLines(lines, file, DEFAULT_CHARSET);
    }

    public static void writeLines(String[] lines, File file, String charset) {
        try (FileOutputStream out = new FileOutputStream(file, false);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);
             BufferedWriter bfw = new BufferedWriter(writer);){
            for (String line : lines) {
                writer.write(line);
                writer.write("\r\n");
            }
            bfw.flush();
            writer.flush();
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstLine(Reader reader) throws IOException {
        try (BufferedReader bfr = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line = null;
            line = bfr.readLine();
            if (line != null) {
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLines(Reader reader) throws IOException {
        try (BufferedReader bfr = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            ArrayList<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = bfr.readLine()) != null) {
                lines.add(line);
            }
            String[] stringArray = lines.toArray(new String[lines.size()]);
            return stringArray;
        }
    }

    public static void writeText(String text, File file) {
        FileUtils.writeText(text, file, DEFAULT_CHARSET);
    }

    public static void writeText(String text, File file, String charset) {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            FileUtils.writeText(text, out, charset);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeBytes(byte[] content, File file) {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void appendBytes(byte[] content, File file) {
        try (FileOutputStream out = new FileOutputStream(file, true);){
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeText(String text, OutputStream out, String charset) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, charset);){
            writer.write(text);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeProperties(Properties props, File file) {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            FileUtils.writeProperties(props, out, DEFAULT_CHARSET);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeProperties(Properties props, File file, String charset) {
        try (FileOutputStream out = new FileOutputStream(file, false);){
            FileUtils.writeProperties(props, out, charset);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static void writeProperties(Properties props, OutputStream out) {
        FileUtils.writeProperties(props, out, DEFAULT_CHARSET);
    }

    public static void writeProperties(Properties props, OutputStream out, String charset) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, charset);){
            props.store(writer, null);
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static String readText(String filePath) {
        try {
            File file = ResourceUtils.getFile((String)filePath);
            return FileUtils.readText(file, DEFAULT_CHARSET);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    public static String readText(String file, String charset) {
        return FileUtils.readText(new File(file), charset);
    }

    public static String readText(File file) {
        return FileUtils.readText(file, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file, String charset) {
        String string;
        FileInputStream in = new FileInputStream(file);
        try {
            string = FileUtils.readText(in, charset);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return string;
    }

    public static String readText(InputStream in) throws IOException {
        return FileUtils.readText(in, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(InputStream in, String charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, charset);){
            StringBuilder content = new StringBuilder();
            char[] buffer = new char[64];
            int len = 0;
            while ((len = reader.read(buffer)) > 0) {
                content.append(buffer, 0, len);
            }
            String string = content.toString();
            return string;
        }
    }

    public static byte[] readBytes(String file) {
        byte[] byArray;
        FileInputStream in = new FileInputStream(file);
        try {
            byArray = BytesUtils.copyToBytes(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return byArray;
    }

    public static byte[] readBytes(File file) {
        byte[] byArray;
        FileInputStream in = new FileInputStream(file);
        try {
            byArray = BytesUtils.copyToBytes(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return byArray;
    }

    public static Properties readProperties(String file) {
        return FileUtils.readProperties(file, DEFAULT_CHARSET);
    }

    public static Properties readProperties(File file) {
        return FileUtils.readProperties(file, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String file, String charset) {
        Properties properties;
        FileInputStream in = new FileInputStream(file);
        try {
            properties = FileUtils.readProperties(in, charset);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(File file, String charset) {
        Properties properties;
        FileInputStream in = new FileInputStream(file);
        try {
            properties = FileUtils.readProperties(in, charset);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return properties;
    }

    public static Properties readProperties(InputStream in) {
        return FileUtils.readProperties(in, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(InputStream in, String charset) {
        Properties properties;
        InputStreamReader reader = new InputStreamReader(in, charset);
        try {
            Properties props = new Properties();
            props.load(reader);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        reader.close();
        return properties;
    }

    public static Properties readPropertiesAndClose(InputStream in) {
        return FileUtils.readPropertiesAndClose(in, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesAndClose(InputStream in, String charset) {
        try {
            Properties properties;
            InputStreamReader reader = new InputStreamReader(in, charset);
            try {
                Properties props = new Properties();
                props.load(reader);
                properties = props;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e.getMessage(), e);
                }
            }
            reader.close();
            return properties;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return file;
    }

    public static String getCurrentDir() {
        try {
            return new File("./").getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static void deleteFile(String dir) {
        FileUtils.deleteFile(dir, false);
    }

    public static void deleteFile(File file) {
        FileUtils.deletePath(file, false);
    }

    public static void deleteFile(String dir, boolean silent) {
        File directory = new File(dir);
        FileUtils.deletePath(directory, silent);
    }

    public static boolean deletePath(File path, boolean silent) {
        if (path.isFile()) {
            try {
                path.delete();
                return true;
            }
            catch (Exception e) {
                if (!silent) {
                    throw new RuntimeIOException(e.getMessage(), e);
                }
                return false;
            }
        }
        File[] files = path.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            FileUtils.deletePath(f, silent);
        }
        return path.delete();
    }

    public static File getFile(String resourceLocation, String parentDir) throws FileNotFoundException {
        if (resourceLocation.startsWith("classpath:")) {
            return ResourceUtils.getFile((String)resourceLocation);
        }
        if (resourceLocation.startsWith("/")) {
            return new File(resourceLocation);
        }
        String totalPath = PathUtils.concatPaths(parentDir, resourceLocation);
        return new File(totalPath);
    }

    public static InputStream read(String resourceLocation, String parentDir) {
        try {
            if (resourceLocation.startsWith("classpath:")) {
                String path = resourceLocation.substring("classpath:".length());
                ClassPathResource resource = new ClassPathResource(path);
                return resource.getInputStream();
            }
            if (resourceLocation.startsWith("/")) {
                return new FileInputStream(new File(resourceLocation));
            }
            String totalPath = PathUtils.concatPaths(parentDir, resourceLocation);
            return new FileInputStream(new File(totalPath));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesResouce(String resourceLocation, String parentDir) throws FileNotFoundException {
        Properties properties;
        InputStream in = FileUtils.read(resourceLocation, parentDir);
        try {
            properties = FileUtils.readProperties(in, DEFAULT_CHARSET);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
        in.close();
        return properties;
    }
}

