/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import utils.io.BytesInputStream;
import utils.io.BytesSlice;
import utils.io.BytesSlices;
import utils.io.NumberMask;

public class FixedBytesSliceArray
implements BytesSlices {
    private byte[] dataBytes;
    private int totalSize;
    private int dataOffset;
    private int itemCount;
    private int itemSize;

    private FixedBytesSliceArray(byte[] dataBytes, int totalSize, int dataOffset, int itemCount, int itemSize) {
        if (dataOffset + itemCount * itemSize > dataBytes.length) {
            throw new IllegalArgumentException("The tail index of all slices is out of bound of data bytes!");
        }
        this.dataBytes = dataBytes;
        this.totalSize = totalSize;
        this.dataOffset = dataOffset;
        this.itemCount = itemCount;
        this.itemSize = itemSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getCount() {
        return this.itemCount;
    }

    @Override
    public BytesSlice getDataSlice(int idx) {
        if (idx < 0 || idx >= this.itemCount) {
            throw new IllegalArgumentException("The specified idx is out of bound!");
        }
        return new BytesSlice(this.dataBytes, this.dataOffset + idx * this.itemSize, this.itemSize);
    }

    public static FixedBytesSliceArray resolve(BytesInputStream bytesStream, int itemSize) {
        int p1 = bytesStream.getPosition();
        int itemCount = (int)NumberMask.NORMAL.resolveMaskedNumber(bytesStream);
        int dataOffset = bytesStream.getPosition();
        bytesStream.skip(itemCount * itemSize);
        int totalSize = bytesStream.getPosition() - p1;
        return new FixedBytesSliceArray(bytesStream.getOriginBytes(), totalSize, dataOffset, itemCount, itemSize);
    }
}

