/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import utils.io.FileUtils;
import utils.io.Storage;

public class MemoryStorage
implements Storage {
    private String name;
    private final Object STORAGE_MUTEX = new Object();
    private Map<String, MemoryStorage> storageMap = new ConcurrentHashMap<String, MemoryStorage>();
    private Map<String, byte[]> dataMap = new ConcurrentHashMap<String, byte[]>();

    public MemoryStorage(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] list() {
        return this.storageMap.keySet().toArray(new String[this.storageMap.size()]);
    }

    private void checkName(String name) {
        if (name.contains(File.separator)) {
            throw new IllegalArgumentException("The name cann't contain the char[" + File.separatorChar + "]!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Storage getStorage(String name) {
        this.checkName(name);
        MemoryStorage storage = this.storageMap.get(name);
        if (storage == null) {
            Object object = this.STORAGE_MUTEX;
            synchronized (object) {
                storage = this.storageMap.get(name);
                if (storage == null) {
                    storage = new MemoryStorage(name);
                    this.storageMap.put(name, storage);
                }
            }
        }
        return storage;
    }

    @Override
    public byte[] readBytes(String name) {
        this.checkName(name);
        byte[] data = this.dataMap.get(name);
        return data == null ? null : (byte[])data.clone();
    }

    @Override
    public void writeBytes(String name, byte[] dataBytes) {
        this.checkName(name);
        this.dataMap.put(name, (byte[])dataBytes.clone());
    }

    @Override
    public InputStream read(String name) {
        this.checkName(name);
        byte[] data = this.dataMap.get(name);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    @Override
    public Properties readProperties(String name) {
        return FileUtils.readProperties(this.read(name));
    }

    @Override
    public void writeProperties(String name, Properties props) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtils.writeProperties(props, out);
        this.dataMap.put(name, out.toByteArray());
    }

    @Override
    public String[] getKeyNames() {
        return this.dataMap.keySet().toArray(new String[this.dataMap.size()]);
    }
}

