/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import utils.io.BytesInputStream;
import utils.io.BytesSlice;
import utils.io.BytesSlices;
import utils.io.NumberMask;

public class SingleBytesSliceArray
extends BytesSlice
implements BytesSlices {
    private int totalSize;

    private SingleBytesSliceArray(byte[] dataBytes, int totalSize, int dataOffset, int dataSize) {
        super(dataBytes, dataOffset, dataSize);
        this.totalSize = totalSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public BytesSlice getDataSlice(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("The specified idx is out of bound!");
        }
        return this;
    }

    public static SingleBytesSliceArray resolveDynamic(BytesInputStream bytesStream) {
        int p1 = bytesStream.getPosition();
        int size = (int)NumberMask.NORMAL.resolveMaskedNumber(bytesStream);
        int dataOffset = bytesStream.getPosition();
        bytesStream.skip(size);
        int totalSize = bytesStream.getPosition() - p1;
        return new SingleBytesSliceArray(bytesStream.getOriginBytes(), totalSize, dataOffset, size);
    }

    public static BytesSlices resolveNumber(NumberMask numberMask, BytesInputStream bytesStream) {
        int p1 = bytesStream.getPosition();
        byte headByte = bytesStream.readByte();
        int size = numberMask.resolveMaskLength(headByte);
        bytesStream.skip(size - 1);
        int totalSize = bytesStream.getPosition() - p1;
        return new SingleBytesSliceArray(bytesStream.getOriginBytes(), totalSize, p1, size);
    }

    public static SingleBytesSliceArray create(BytesInputStream bytesStream, int itemSize) {
        int offset = bytesStream.getPosition();
        bytesStream.skip(itemSize);
        return new SingleBytesSliceArray(bytesStream.getOriginBytes(), itemSize, offset, itemSize);
    }

    public static SingleBytesSliceArray create(byte[] dataBytes, int offset, int size) {
        return new SingleBytesSliceArray(dataBytes, size, offset, size);
    }
}

