/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.InputStream;
import java.util.Properties;
import utils.io.BytesUtils;

public interface Storage {
    public String getName();

    public String[] list();

    public Storage getStorage(String var1);

    public byte[] readBytes(String var1);

    public void writeBytes(String var1, byte[] var2);

    public InputStream read(String var1);

    public Properties readProperties(String var1);

    public void writeProperties(String var1, Properties var2);

    public String[] getKeyNames();

    default public int readInt(String name) {
        return this.readInt(name, 0);
    }

    default public int readInt(String name, int defaultValue) {
        byte[] bytes = this.readBytes(name);
        return bytes == null ? defaultValue : BytesUtils.toInt(bytes);
    }

    default public void writeInt(String name, int value) {
        this.writeBytes(name, BytesUtils.toBytes(value));
    }
}

