/*
 * Decompiled with CFR 0.152.
 */
package utils.net;

import java.io.Serializable;
import java.util.Arrays;
import utils.io.BytesOutputBuffer;
import utils.io.BytesSerializable;
import utils.io.BytesUtils;

public class NetworkAddress
implements BytesSerializable,
Serializable {
    private static final long serialVersionUID = -4565279525154132393L;
    private String host;
    private int port;
    private boolean secure;

    public NetworkAddress() {
    }

    public NetworkAddress(String host, int port) {
        this(host, port, false);
    }

    public NetworkAddress(String host, int port, boolean secure) {
        this.host = host;
        this.port = port;
        this.secure = secure;
    }

    public NetworkAddress(byte[] serializeBytes) {
        this.secure = serializeBytes[0] == 1;
        this.port = BytesUtils.toInt(serializeBytes, 1);
        this.host = BytesUtils.toString(serializeBytes, 5);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String toString() {
        return this.secure ? String.format("secure://%s:%s", this.host, this.port) : String.format("%s:%s", this.host, this.port);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.host, this.port, this.secure});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NetworkAddress) {
            NetworkAddress other = (NetworkAddress)obj;
            return this.host.equals(other.host) && this.port == other.port && this.secure == other.secure;
        }
        return false;
    }

    @Override
    public byte[] toBytes() {
        BytesOutputBuffer buffer = new BytesOutputBuffer();
        byte[] bf1 = new byte[5];
        bf1[0] = this.secure ? (byte)1 : 0;
        BytesUtils.toBytes(this.port, bf1, 1);
        buffer.write(bf1);
        buffer.write(BytesUtils.toBytes(this.host));
        return buffer.toBytes();
    }
}

