/*
 * Decompiled with CFR 0.152.
 */
package utils.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import utils.codec.HexUtils;
import utils.security.DecryptionException;
import utils.security.EncryptionException;
import utils.security.RandomUtils;
import utils.security.ShaUtils;

@Deprecated
public class AESUtils {
    public static String generateKey128_Hex(byte[] seed) {
        byte[] keyBytes = AESUtils.generateKey128_Bytes(seed);
        return HexUtils.encode(keyBytes);
    }

    public static byte[] generateKey128_Bytes(byte[] seed) {
        SecretKey key = AESUtils.generateKey128(seed);
        return key.getEncoded();
    }

    public static SecretKey generateKey128(byte[] seed) {
        if (seed == null || seed.length == 0) {
            throw new IllegalArgumentException("Empty seed!");
        }
        byte[] hashBytes = ShaUtils.hash_128(seed);
        return new SecretKeySpec(hashBytes, "AES");
    }

    public static SecretKey generateKey128() {
        byte[] randBytes = RandomUtils.generateRandomBytes(16);
        return new SecretKeySpec(randBytes, "AES");
    }

    public static String generateKey128_Hex() {
        byte[] keyBytes = AESUtils.generateKey128_Bytes();
        return HexUtils.encode(keyBytes);
    }

    public static byte[] generateKey128_Bytes() {
        SecretKey key = AESUtils.generateKey128();
        return key.getEncoded();
    }

    public static byte[] encrypt(byte[] content, String key) {
        return AESUtils.encrypt(content, HexUtils.decode(key));
    }

    public static byte[] encrypt(byte[] content, byte[] secretKey) {
        SecretKeySpec aesKey = new SecretKeySpec(secretKey, "AES");
        return AESUtils.encrypt(content, aesKey);
    }

    public static byte[] encrypt(byte[] plainBytes, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            return cipher.doFinal(plainBytes);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
    }

    public static byte[] decrypt(byte[] encryptedBytes, String key) {
        return AESUtils.decrypt(encryptedBytes, HexUtils.decode(key));
    }

    public static byte[] decrypt(byte[] encryptedBytes, byte[] key) {
        SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
        return AESUtils.decrypt(encryptedBytes, aesKey);
    }

    public static byte[] decrypt(byte[] encryptedBytes, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return cipher.doFinal(encryptedBytes);
        }
        catch (InvalidKeyException e) {
            throw new DecryptionException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecryptionException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new DecryptionException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecryptionException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new DecryptionException(e.getMessage(), e);
        }
    }
}

