/*
 * Decompiled with CFR 0.152.
 */
package utils.security;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

@Deprecated
public class Ed25519Utils {
    public static byte[] sign_512(byte[] data, byte[] privateKey) {
        return Ed25519Utils.sign_512(ByteBuffer.wrap(data), privateKey);
    }

    public static byte[] sign_512(ByteBuffer data, byte[] privateKey) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
            EdDSAPrivateKeySpec privateKeySpec = new EdDSAPrivateKeySpec(privateKey, (EdDSAParameterSpec)spec);
            EdDSAPrivateKey privKey = new EdDSAPrivateKey(privateKeySpec);
            sgr.initSign((PrivateKey)privKey);
            sgr.update(data);
            return sgr.sign();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static boolean verify(byte[] plainData, byte[] pubKeyBytes, byte[] signatureBytes) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
            EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(pubKeyBytes, (EdDSAParameterSpec)spec);
            EdDSAPublicKey pubKey = new EdDSAPublicKey(pubKeySpec);
            sgr.initVerify((PublicKey)pubKey);
            sgr.update(plainData);
            return sgr.verify(signatureBytes);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

