/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.base;

import java.security.SecureRandom;
import utils.io.BytesUtils;

public abstract class HashBaseSecureRandom
extends SecureRandom {
    private static final long serialVersionUID = 5041705497618740310L;
    private final int HASH_SIZE;
    private final int OUTPUT_OFFSET = this.HASH_SIZE = this.getHashSize();
    private final int COUNTER_OFFSET = this.OUTPUT_OFFSET * 2;
    private byte[] state;
    private long i = 0L;
    private byte[] output;
    private int availableSize;

    public HashBaseSecureRandom(byte[] seed) {
        byte[] initState = new byte[this.COUNTER_OFFSET + 8];
        this.hash(seed, initState, 0);
        System.arraycopy(initState, 0, initState, this.OUTPUT_OFFSET, this.HASH_SIZE);
        this.i = 0L;
        BytesUtils.toBytes((long)this.i, (byte[])initState, (int)this.COUNTER_OFFSET);
        this.output = new byte[this.HASH_SIZE];
        this.availableSize = 0;
        this.state = initState;
    }

    private void nextState() {
        BytesUtils.toBytes((long)(++this.i), (byte[])this.state, (int)this.COUNTER_OFFSET);
        this.hash(this.state, this.output, 0);
        System.arraycopy(this.output, 0, this.state, this.OUTPUT_OFFSET, this.HASH_SIZE);
        this.availableSize = this.HASH_SIZE;
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        this.nextBytes(bytes, 0, bytes.length);
    }

    public synchronized void nextBytes(byte[] bytes, int offset, int length) {
        int left = length;
        int pos = offset;
        while (left > 0) {
            if (this.availableSize == 0) {
                this.nextState();
            }
            int copySize = Math.min(left, this.availableSize);
            System.arraycopy(this.output, this.HASH_SIZE - this.availableSize, bytes, pos, copySize);
            pos += copySize;
            left -= copySize;
            this.availableSize -= copySize;
        }
    }

    protected abstract int getHashSize();

    protected abstract void hash(byte[] var1, byte[] var2, int var3);
}

