/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm;

import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import utils.crypto.sm.SM3Utils;
import utils.security.DecryptionException;
import utils.security.EncryptionException;

public class SM4Utils {
    public static final int KEY_SIZE = 16;
    public static final int BLOCK_SIZE = 16;
    public static final int IV_SIZE = 16;

    public static byte[] generateKey() {
        CipherKeyGenerator keyGenerator = new CipherKeyGenerator();
        keyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 128));
        return keyGenerator.generateKey();
    }

    public static byte[] generateKey(byte[] seed) {
        byte[] hash = SM3Utils.hash(seed);
        return Arrays.copyOf(hash, 16);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] secretKey, byte[] iv) {
        return SM4Utils.encrypt(plainBytes, 0, plainBytes.length, secretKey, iv);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] secretKey, byte[] iv) {
        if (plainBytes == null) {
            throw new IllegalArgumentException("plaintext is null!");
        }
        if (secretKey.length != 16) {
            throw new EncryptionException("secretKey's length is wrong!");
        }
        if (iv.length != 16) {
            throw new EncryptionException("iv's length is wrong!");
        }
        int padding = 16 - length % 16;
        byte[] plainBytesWithPadding = new byte[length + padding];
        System.arraycopy(plainBytes, offset, plainBytesWithPadding, 0, length);
        PKCS7Padding padder = new PKCS7Padding();
        padder.addPadding(plainBytesWithPadding, length);
        CBCBlockCipher encryptor = new CBCBlockCipher((BlockCipher)new SM4Engine());
        encryptor.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(secretKey), iv));
        byte[] output = new byte[plainBytesWithPadding.length + 16];
        int blockCount = plainBytesWithPadding.length / 16;
        int outOffset = 0;
        for (int i = 0; i < blockCount; ++i) {
            encryptor.processBlock(plainBytesWithPadding, outOffset, output, outOffset + 16);
            outOffset += 16;
        }
        System.arraycopy(iv, 0, output, 0, 16);
        return output;
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] secretKey) {
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        return SM4Utils.encrypt(plainBytes, offset, length, secretKey, iv);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] secretKey) {
        return SM4Utils.encrypt(plainBytes, 0, plainBytes.length, secretKey);
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] secretKey) {
        return SM4Utils.decrypt(cipherBytes, 0, cipherBytes.length, secretKey);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, byte[] secretKey) {
        if (cipherBytes == null) {
            throw new IllegalArgumentException("ciphertext is null!");
        }
        if (length % 16 != 0) {
            throw new DecryptionException("ciphertext's length is wrong!");
        }
        if (secretKey.length != 16) {
            throw new DecryptionException("secretKey's length is wrong!");
        }
        byte[] iv = new byte[16];
        System.arraycopy(cipherBytes, offset, iv, 0, 16);
        CBCBlockCipher decryptor = new CBCBlockCipher((BlockCipher)new SM4Engine());
        decryptor.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(secretKey), iv));
        byte[] outputWithPadding = new byte[length - 16];
        int blockCount = length / 16;
        int outOffset = 0;
        for (int i = 1; i < blockCount; ++i) {
            decryptor.processBlock(cipherBytes, outOffset + offset + 16, outputWithPadding, outOffset);
            outOffset += 16;
        }
        int p = outputWithPadding[outputWithPadding.length - 1];
        if (p > 16 || p < 1) {
            throw new DecryptionException("There no exists such padding!");
        }
        for (int i = 0; i < p; ++i) {
            if (outputWithPadding[outputWithPadding.length - i - 1] == p) continue;
            throw new DecryptionException("Padding is invalid!");
        }
        byte[] output = new byte[outputWithPadding.length - p];
        System.arraycopy(outputWithPadding, 0, output, 0, output.length);
        return output;
    }
}

