/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import utils.io.BytesUtils;
import utils.io.RuntimeIOException;
import utils.serialize.binary.FilteredObjectInputStream;

public class BinarySerializeUtils {
    public static byte[] serialize(Object object) {
        if (object == null) {
            return BytesUtils.EMPTY_BYTES;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinarySerializeUtils.serialize(object, out);
        return out.toByteArray();
    }

    public static void serialize(Object object, OutputStream out) {
        if (object == null) {
            return;
        }
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(object);
            objOut.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return BinarySerializeUtils.deserialize(in);
    }

    public static <T> T deserialize(byte[] bytes, int offset, int length) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes, offset, length);
        return BinarySerializeUtils.deserialize(in);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream in) {
        try (FilteredObjectInputStream objIn = new FilteredObjectInputStream(in);){
            Object obj;
            Object object = obj = objIn.readObject();
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> T copyOf(T obj) {
        byte[] bts = BinarySerializeUtils.serialize(obj);
        return BinarySerializeUtils.deserialize(bts);
    }
}

