/*
 * Decompiled with CFR 0.152.
 */
package utils.serialize.json;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.spi.Module;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import utils.ArrayUtils;
import utils.serialize.json.BeanTypeSerializer;
import utils.serialize.json.DynamicTypeConverter;

class DynamicTypeConfigureModule
implements Module {
    public static final DynamicTypeConfigureModule INSTANCE = new DynamicTypeConfigureModule();
    private Map<Class<?>, ObjectSerializer> serializers = new ConcurrentHashMap();
    private volatile DynamicTypeConverter[] converters = new DynamicTypeConverter[0];

    private DynamicTypeConfigureModule() {
    }

    public synchronized void register(DynamicTypeConverter typeConverter) {
        for (DynamicTypeConverter cvt : this.converters) {
            if (cvt != typeConverter) continue;
            return;
        }
        this.converters = (DynamicTypeConverter[])ArrayUtils.concat((Object[])this.converters, (Object)typeConverter, DynamicTypeConverter.class);
    }

    public ObjectDeserializer createDeserializer(ParserConfig config, Class type) {
        return null;
    }

    public ObjectSerializer createSerializer(SerializeConfig config, Class type) {
        Object serializer = this.serializers.get(type);
        if (serializer != null) {
            return serializer;
        }
        Class<?> serializeType = this.getSerializeType(type);
        if (serializeType != null) {
            serializer = new BeanTypeSerializer(serializeType);
            this.serializers.put(type, (ObjectSerializer)serializer);
            config.put((Type)type, serializer);
            config.put(serializeType, serializer);
            return serializer;
        }
        return null;
    }

    private Class<?> getSerializeType(Class<?> type) {
        Class<?> stype = null;
        for (DynamicTypeConverter cvt : this.converters) {
            stype = cvt.getSerializeType(type);
            if (stype == null) continue;
            return stype;
        }
        return null;
    }
}

